package com.yifu.cloud.plus.v1.yifu.process.config;

import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.config.MybatisPlusMetaObjectHandler;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.plugins.YifuPaginationInnerInterceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

import javax.sql.DataSource;

/**
 * @author chenyuxi
 * @date 2025-01-10
 * @since 1.7.5
 */
@Configuration
@MapperScan(basePackages = "com.yifu.cloud.plus.v1.yifu.process.mapper", sqlSessionTemplateRef = "processSqlSessionTemplate", sqlSessionFactoryRef = "processSqlSessionFactory")
public class ProcessDataSourceConfig {

	@Bean(name = "processDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.process")
	@Primary
    public DataSource processDataSource() {
		         return DataSourceBuilder.create().build();
	}
	@Bean
     public SqlSessionFactory processSqlSessionFactory(@Qualifier("processDataSource") DataSource dataSource) throws Exception {

		MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
		bean.setDataSource(dataSource);
		//多数据源 myMetaObjectHandler不起作用问题解决
		GlobalConfig globalConfig = new GlobalConfig();
		globalConfig.setMetaObjectHandler(new MybatisPlusMetaObjectHandler());
		globalConfig.setDbConfig(new GlobalConfig.DbConfig());
		globalConfig.setBanner(false);
		bean.setGlobalConfig(globalConfig);
		//添加XML目录
		ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
		try {
			bean.setMapperLocations(resolver.getResources("classpath:mapper/*.xml"));
			//分页插件配置,不配置分页插件无效,否则会出现total为0的情况
			bean.setPlugins(processPlusInterceptor());
			SqlSessionFactory sqlSessionFactory = bean.getObject();
			sqlSessionFactory.getConfiguration().setMapUnderscoreToCamelCase(true);
			return sqlSessionFactory;
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}


	@Bean(name = "processTransactionManager")
	@Primary
	public DataSourceTransactionManager processTransactionManager(@Qualifier("processDataSource") DataSource dataSource) {
		         return new DataSourceTransactionManager(dataSource);
	}
	@Bean
     public SqlSessionTemplate processSqlSessionTemplate(@Qualifier("processSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		        return new SqlSessionTemplate(sqlSessionFactory);
	}
	@Bean
	public TransactionTemplate processTransactionTemplate(@Qualifier("processTransactionManager") DataSourceTransactionManager dataSourceTransactionManager) {
	         return new TransactionTemplate(dataSourceTransactionManager);
   }

	@Bean
	public MybatisPlusInterceptor processPlusInterceptor() {
		MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
		interceptor.addInnerInterceptor(new YifuPaginationInnerInterceptor());
		return interceptor;
	}
}
