package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeConfig;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodeConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * 流程节点配置表（规则配置）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tnodeconfig")
@Tag(name = "流程节点配置表（规则配置）")
public class TNodeConfigController {

	 @Resource
     private TNodeConfigService tNodeConfigService;

     /**
      * 简单分页查询
      *
      * @param page        分页对象
      * @param tNodeConfig 流程节点配置表（规则配置）
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TNodeConfig>> getTNodeConfigPage(Page<TNodeConfig> page, TNodeConfig tNodeConfig) {
          return new R<>(tNodeConfigService.getTNodeConfigPage(page, tNodeConfig));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TNodeConfig> getById(@PathVariable("id") String id) {
          return new R<>(tNodeConfigService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tNodeConfig
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TNodeConfig tNodeConfig) {
          return new R<>(tNodeConfigService.save(tNodeConfig));
     }

     /**
      * 修改记录
      *
      * @param tNodeConfig
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改流程节点配置表（规则配置）")
     @PutMapping
     public R<Boolean> update(@RequestBody TNodeConfig tNodeConfig) {
          return new R<>(tNodeConfigService.updateById(tNodeConfig));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除流程节点配置表（规则配置）")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tNodeConfigService.removeById(id));
     }

}
