package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeTimeoutConfig;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodeTimeoutConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * 节点超时配置表
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tnodetimeoutconfig")
@Tag(name = "节点超时配置表")
public class TNodeTimeoutConfigController {

	@Resource
     private TNodeTimeoutConfigService tNodeTimeoutConfigService;

     /**
      * 简单分页查询
      *
      * @param page               分页对象
      * @param tNodeTimeoutConfig 节点超时配置表
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TNodeTimeoutConfig>> getTNodeTimeoutConfigPage(Page<TNodeTimeoutConfig> page, TNodeTimeoutConfig tNodeTimeoutConfig) {
          return new R<>(tNodeTimeoutConfigService.getTNodeTimeoutConfigPage(page, tNodeTimeoutConfig));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TNodeTimeoutConfig> getById(@PathVariable("id") String id) {
          return new R<>(tNodeTimeoutConfigService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tNodeTimeoutConfig
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TNodeTimeoutConfig tNodeTimeoutConfig) {
          return new R<>(tNodeTimeoutConfigService.save(tNodeTimeoutConfig));
     }

     /**
      * 修改记录
      *
      * @param tNodeTimeoutConfig
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改节点超时配置表")
     @PutMapping
     public R<Boolean> update(@RequestBody TNodeTimeoutConfig tNodeTimeoutConfig) {
          return new R<>(tNodeTimeoutConfigService.updateById(tNodeTimeoutConfig));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除节点超时配置表")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tNodeTimeoutConfigService.removeById(id));
     }

}
