package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 薪资原表识别明细表
 *
 * @author hgw
 * @date 2024-4-1 18:10:43
 */
@Data
@TableName("t_salary_standard_original_detail")
@Tag(name = "薪资原表识别明细表")
public class TSalaryStandardOriginalDetail {
	private static final long serialVersionUID = 1L;
	/**
	 *
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
	private String id;
	/**
	 * TSalaryStandardOriginal表的主键
	 */
	@NotBlank(message = "TSalaryStandardOriginal表的主键不能为空")
	@Length(max = 32, message = "TSalaryStandardOriginal表的主键不能超过32个字符")
	@ExcelAttribute(name = "TSalaryStandardOriginal表的主键", isNotEmpty = true, errorInfo = "不能为空", maxLength = 32)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "TSalaryStandardOriginal表的主键")
	private String originalId;
	/**
	 * 表格列号
	 */
	@ExcelAttribute(name = "表格列号", isNotEmpty = true, errorInfo = "表格列号不能为空")
	@NotBlank(message = "表格列号不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("表格列号")
	private Integer columnNo;
	/**
	 * 原表表头
	 */
	@Length(max = 50, message = "原表表头不能超过50个字符")
	@ExcelAttribute(name = "原表表头", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "原表表头")
	private String excelName;
	/**
	 * 原表计算规则，默认空为 等于，可选包含
	 */
	@Length(max = 50, message = "原表计算规则不能超过50个字符")
	@ExcelAttribute(name = "原表计算规则", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "原表计算规则")
	private String excelRule;
	/**
	 * 原表表头关键字
	 */
	@Length(max = 50, message = "原表表头关键字不能超过50个字符")
	@ExcelAttribute(name = "原表表头关键字", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "原表表头关键字")
	private String excelKey;
	/**
	 * 模板表头
	 */
	@Length(max = 50, message = "模板表头不能超过50个字符")
	@ExcelAttribute(name = "模板表头", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "模板表头")
	private String modelName;
	/**
	 * 公式标志：MAIN主；ADD加；REDUCE减
	 */
	@Length(max = 50, message = "公式标志不能超过50个字符")
	@ExcelAttribute(name = "公式标志", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公式标志：MAIN主；ADD加；REDUCE减")
	private String flag;
	/**
	 * 公式顺序编号（前端使用）
	 */
	@ExcelAttribute(name = "公式顺序编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公式顺序编号")
	private Integer formulaNo;
}
