package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;


/**
 * @Author fxj
 * @Description 专项扣除
 * @Date 13:40 2022/8/6
 * @Param
 * @return
**/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_special_deducation_sum")
@Tag(name = "专项扣除")
public class TSpecialDeducationSum extends BaseEntity {
     private static final long serialVersionUID = 1L;
     /**
      * id
      */
     @TableId(type = IdType.ASSIGN_ID)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "id")
     private String id;
     /**
      * 导入月份
      */
     @NotBlank(message = "导入月份不能为空")
     @Length(max = 6, message = "导入月份不能超过6个字符")
     @ExcelAttribute(name = "导入月份",  maxLength = 6)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "导入月份")
     private String createMonth;
     /**
      * 申报单位
      */
     @Length(max = 50, message = "申报单位不能超过50个字符")
     @ExcelAttribute(name = "申报单位", maxLength = 50, isNotEmpty = true)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "申报单位")
     private String declareTitle;
     /**
      * 工号
      */
     @Length(max = 50, message = "工号不能超过50个字符")
     @ExcelAttribute(name = "工号", maxLength = 50)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "工号")
     private String jobNumber;
     /**
      * 姓名
      */
     @Length(max = 20, message = "姓名不能超过20个字符")
     @ExcelAttribute(name = "姓名", maxLength = 20, isNotEmpty = true)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "姓名")
     private String name;
     /**
      * 证照类型
      */
     @Length(max = 20, message = "证照类型不能超过20个字符")
     @ExcelAttribute(name = "证照类型", maxLength = 20, isNotEmpty = true)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "证照类型")
     private String type;
     /**
      * 证照号码
      */
     @Length(max = 20, message = "证照号码不能超过20个字符")
     @ExcelAttribute(name = "证照号码", maxLength = 20, isNotEmpty = true)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "证照号码")
     private String idNumber;
     /**
      * 所得期间起
      */
     @Length(max = 20, message = "所得期间起不能超过20个字符")
     @ExcelAttribute(name = "所得期间起", maxLength = 20, isNotEmpty = true)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "所得期间起")
     private String createStart;
     /**
      * 所得期间止
      */
     @Length(max = 20, message = "所得期间止不能超过20个字符")
     @ExcelAttribute(name = "所得期间止", maxLength = 20, isNotEmpty = true)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "所得期间止")
     private String createEnd;
     /**
      * 本期收入
      */
     @ExcelAttribute(name = "本期收入", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "本期收入")
     private BigDecimal currentIncome;
     /**
      * 本期免税收入
      */
     @ExcelAttribute(name = "本期免税收入", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "本期免税收入")
     private BigDecimal currentIncomeTaxFree;
     /**
      * 基本医疗保险费
      */
     @ExcelAttribute(name = "基本医疗保险费", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "基本医疗保险费")
     private BigDecimal insurancePension;
     /**
      * 基本医疗保险费
      */
     @ExcelAttribute(name = "基本医疗保险费", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "基本医疗保险费")
     private BigDecimal insuranceMedical;
     /**
      * 失业保险费
      */
     @ExcelAttribute(name = "失业保险费", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "失业保险费")
     private BigDecimal insuranceUnemployment;
     /**
      * 住房公积金
      */
     @ExcelAttribute(name = "住房公积金", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "住房公积金")
     private BigDecimal fund;
     /**
      * 累计子女教育
      */
     @ExcelAttribute(name = "累计子女教育", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计子女教育")
     private BigDecimal sumChildEduMoney;
     /**
      * 累计住房贷款利息
      */
     @ExcelAttribute(name = "累计住房贷款利息", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计住房贷款利息")
     private BigDecimal sumHousingLoanMoney;
     /**
      * 累计住房租金
      */
     @ExcelAttribute(name = "累计住房租金", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计住房租金")
     private BigDecimal sumHousingRentMoney;
     /**
      * 累计赡养老人
      */
     @ExcelAttribute(name = "累计赡养老人", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计赡养老人")
     private BigDecimal sumSupportElderlyMoney;
     /**
      * 累计继续教育
      */
     @ExcelAttribute(name = "累计继续教育", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计继续教育")
     private BigDecimal sumContinuingEducationMoney;

     /**
      * 累计3岁以下婴幼儿照护 (累计3岁以下婴幼儿照护)
      * hgw 2022-4-2 11:05:44 樊青青提的需求
      */
     @ExcelAttribute(name = "累计3岁以下婴幼儿照护", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计3岁以下婴幼儿照护")
     private BigDecimal sumBabyMoney;

	 /**
      * 累计个人养老金
      * hgw 2022-12-13 17:15:48 樊青青提的需求
      */
     @ExcelAttribute(name = "累计个人养老金", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计个人养老金")
     private BigDecimal sumPrivatePension;

     /**
      * 企业(职业)年金
      */
     @ExcelAttribute(name = "企业(职业)年金", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "企业(职业)年金")
     private BigDecimal enterpriseAnnuity;
     /**
      * 商业健康保险
      */
     @ExcelAttribute(name = "商业健康保险", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商业健康保险")
     private BigDecimal takingRisks;
     /**
      * 税延养老保险
      */
     @ExcelAttribute(name = "税延养老保险", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "税延养老保险")
     private BigDecimal taxDeferredInsurance;
     /**
      * 其他
      */
     @ExcelAttribute(name = "其他", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "其他")
     private BigDecimal otherMoney;
     /**
      * 准予扣除的捐赠额
      */
     @ExcelAttribute(name = "准予扣除的捐赠额", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "准予扣除的捐赠额")
     private BigDecimal donationAmount;
     /**
      * 税前扣除项目合计
      */
     @ExcelAttribute(name = "税前扣除项目合计", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "税前扣除项目合计")
     private BigDecimal preTaxDeduction;
     /**
      * 减免税额
      */
     @ExcelAttribute(name = "减免税额", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减免税额")
     private BigDecimal taxSavings;
     /**
      * 减除费用
      */
     @ExcelAttribute(name = "减除费用", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减除费用")
     private BigDecimal costReduction;
     /**
      * 已扣缴税额
      */
     @ExcelAttribute(name = "已扣缴税额", isFloat = true,max = "999999999.99")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "已扣缴税额")
     private BigDecimal taxesWithheld;
     /**
      * 备注
      */
     @Length(max = 500, message = "备注不能超过500个字符")
     @ExcelAttribute(name = "备注", maxLength = 500)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "备注")
     private String remark;
}
