/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 工资缴费库-同步表（同步完成后真删除数据）
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class MSalaryPaymentResVo extends RowIndex implements Serializable {

	/**
	 * 缴费库id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "缴费库id 不能为空")
	@Length(max = 32, message = "缴费库id 不能超过32 个字符")
	@ExcelAttribute(name = "缴费库id", isNotEmpty = true, errorInfo = "缴费库id 不能为空", maxLength = 32)
	@Schema(description = "缴费库id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴费库id")
	private String id;
	/**
	 * 结算主体id
	 */
	@NotBlank(message = "结算主体id 不能为空")
	@Length(max = 50, message = "结算主体id 不能超过50 个字符")
	@ExcelAttribute(name = "结算主体id", isNotEmpty = true, errorInfo = "结算主体id 不能为空", maxLength = 50)
	@Schema(description = "结算主体id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算主体id")
	private String deptId;
	/**
	 * 工资社保结算状态  0: 未结算  1:  已结算
	 */
	@Length(max = 1, message = "工资社保结算状态  0: 未结算  1:  已结算 不能超过1 个字符")
	@ExcelAttribute(name = "工资社保结算状态  0: 未结算  1:  已结算", maxLength = 1)
	@Schema(description = "工资社保结算状态  0: 未结算  1:  已结算")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资社保结算状态  0: 未结算  1:  已结算")
	private String salarySocialFlag;
	/**
	 * 工资公积金结算状态  0: 未结算  1: 已结算
	 */
	@Length(max = 1, message = "工资公积金结算状态  0: 未结算  1: 已结算 不能超过1 个字符")
	@ExcelAttribute(name = "工资公积金结算状态  0: 未结算  1: 已结算", maxLength = 1)
	@Schema(description = "工资公积金结算状态  0: 未结算  1: 已结算")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资公积金结算状态  0: 未结算  1: 已结算")
	private String salaryFundFlag;

}
