package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 前12月平均工资（MVP-TDC接口）
 * 保留上月与本月，删除上上月数据，用以比对差异部分，推送到TDC
 *
 * @author hgw
 * @date 2023-6-19 15:54:50
 */
@Data
public class TAverageSalaryVo implements Serializable {

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 25)
	@Length(max = 25, message = "身份证号不能超过25个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 应发薪酬（劳务费、稿酬）
	 */
	@ExcelAttribute(name = "应发薪酬")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("应发薪酬")
	private BigDecimal averageSalary;

}
