/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 薪资结算附件表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryAttaVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 附件名称
	 */
	@NotBlank(message = "附件名称 不能为空")
	@Length(max = 200, message = "附件名称 不能超过200 个字符")
	@ExcelAttribute(name = "附件名称", isNotEmpty = true, errorInfo = "附件名称 不能为空", maxLength = 200)
	@Schema(description = "附件名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("附件名称")
	private String attaName;
	/**
	 * 资源路径
	 */
	@NotBlank(message = "资源路径 不能为空")
	@Length(max = 200, message = "资源路径 不能超过200 个字符")
	@ExcelAttribute(name = "资源路径", isNotEmpty = true, errorInfo = "资源路径 不能为空", maxLength = 200)
	@Schema(description = "资源路径")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源路径")
	private String attaSrc;
	/**
	 * 资源地址
	 */
	@Length(max = 100, message = "资源地址 不能超过100 个字符")
	@ExcelAttribute(name = "资源地址", maxLength = 100)
	@Schema(description = "资源地址")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源地址")
	private String attaUrl;
	/**
	 * 资源大小
	 */
	@NotBlank(message = "资源大小 不能为空")
	@ExcelAttribute(name = "资源大小", isNotEmpty = true, errorInfo = "资源大小 不能为空")
	@Schema(description = "资源大小")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源大小")
	private Long attaSize;
	/**
	 * 资源类型（数据字典）
	 */
	@NotBlank(message = "资源类型（数据字典） 不能为空")
	@Length(max = 32, message = "资源类型（数据字典） 不能超过32 个字符")
	@ExcelAttribute(name = "资源类型（数据字典）", isNotEmpty = true, errorInfo = "资源类型（数据字典） 不能为空", maxLength = 32)
	@Schema(description = "资源类型（数据字典）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源类型（数据字典）")
	private String attaType;
	/**
	 * 链接ID
	 */
	@Length(max = 32, message = "链接ID 不能超过32 个字符")
	@ExcelAttribute(name = "链接ID", maxLength = 32)
	@Schema(description = "链接ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("链接ID")
	private String linkId;
	/**
	 * 类型：0工资；1工程工资；2暂停发；3自定义项暂停发；4打印记录；5核准表打印记录;6：非扣税项；8自有员工附件；9财务回执附件
	 */
	@ExcelAttribute(name = "类型：0工资；1工程工资；2暂停发；3自定义项暂停发；4打印记录；5核准表打印记录;6：非扣税项；8自有员工附件；9财务回执附件")
	@Schema(description = "类型：0工资；1工程工资；2暂停发；3自定义项暂停发；4打印记录；5核准表打印记录;6：非扣税项；8自有员工附件；9财务回执附件")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0工资；1工程工资；2暂停发；3自定义项暂停发；4打印记录；5核准表打印记录;6：非扣税项；8自有员工附件；9财务回执附件")
	private Integer linkType;
	/**
	 * 工程文件类型：0三方协议；1委托付款函；2劳务费
	 */
	@ExcelAttribute(name = "工程文件类型：0三方协议；1委托付款函；2劳务费")
	@Schema(description = "工程文件类型：0三方协议；1委托付款函；2劳务费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工程文件类型：0三方协议；1委托付款函；2劳务费")
	private Integer engineerType;
	/**
	 * 打印记录
	 */
	@Length(max = 500, message = "打印记录 不能超过500 个字符")
	@ExcelAttribute(name = "打印记录", maxLength = 500)
	@Schema(description = "打印记录")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("打印记录")
	private String printRemark;
	/**
	 * 工程暂停发的发放记录id
	 */
	@Length(max = 32, message = "工程暂停发的发放记录id 不能超过32 个字符")
	@ExcelAttribute(name = "工程暂停发的发放记录id", maxLength = 32)
	@Schema(description = "工程暂停发的发放记录id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工程暂停发的发放记录id")
	private String recordId;
	/**
	 * 工程暂停发的发放记录id
	 */
	@ExcelAttribute(name = "工程暂停发的发放记录id")
	@Schema(description = "工程暂停发的发放记录id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工程暂停发的发放记录id")
	private Integer recordStatus;

}
