/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 工资报表配置-薪资配置6
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryConfigStandardVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 中文名（Excel表头）
	 */
	@NotBlank(message = "中文名（Excel表头） 不能为空")
	@Length(max = 32, message = "中文名（Excel表头） 不能超过32 个字符")
	@ExcelAttribute(name = "中文名（Excel表头）", isNotEmpty = true, errorInfo = "中文名（Excel表头） 不能为空", maxLength = 32)
	@Schema(description = "中文名（Excel表头）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("中文名（Excel表头）")
	private String cnName;
	/**
	 * 数据库字段名
	 */
	@Length(max = 32, message = "数据库字段名 不能超过32 个字符")
	@ExcelAttribute(name = "数据库字段名", maxLength = 32)
	@Schema(description = "数据库字段名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据库字段名")
	private String dbFiedName;
	/**
	 * JAVA属性字段名
	 */
	@Length(max = 32, message = "JAVA属性字段名 不能超过32 个字符")
	@ExcelAttribute(name = "JAVA属性字段名", maxLength = 32)
	@Schema(description = "JAVA属性字段名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("JAVA属性字段名")
	private String javaFiedName;
	/**
	 * 模板类型（数据字典）
	 */
	@NotBlank(message = "模板类型（数据字典） 不能为空")
	@Length(max = 32, message = "模板类型（数据字典） 不能超过32 个字符")
	@ExcelAttribute(name = "模板类型（数据字典）", isNotEmpty = true, errorInfo = "模板类型（数据字典） 不能为空", maxLength = 32)
	@Schema(description = "模板类型（数据字典）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("模板类型（数据字典）")
	private String modelType;
	/**
	 * 是否是必须
	 */
	@NotBlank(message = "是否是必须 不能为空")
	@Length(max = 1, message = "是否是必须 不能超过1 个字符")
	@ExcelAttribute(name = "是否是必须", isNotEmpty = true, errorInfo = "是否是必须 不能为空", maxLength = 1)
	@Schema(description = "是否是必须")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否是必须")
	private String isMustNeed;
	/**
	 * 是否进行计算扣税：1：计算；0：不计算
	 */
	@NotBlank(message = "是否进行计算扣税：1：计算；0：不计算 不能为空")
	@ExcelAttribute(name = "是否进行计算扣税：1：计算；0：不计算", isNotEmpty = true, errorInfo = "是否进行计算扣税：1：计算；0：不计算 不能为空")
	@Schema(description = "是否进行计算扣税：1：计算；0：不计算")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否进行计算扣税：1：计算；0：不计算")
	private Integer isTax;
	
	/**
	 * 排序项
	 */
	@ExcelAttribute(name = "排序项")
	@Schema(description = "排序项")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("排序项")
	private Integer orderLine;

}
