/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 全年一次性奖金申报表
 *
 * @author huyc
 * @date 2022-08-14 21:31:15
 */
@Data
public class TStatisticsBonusVo extends RowIndex implements Serializable {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "ID 不能为空")
	@Length(max = 32, message = "ID 不能超过32 个字符")
	@ExcelAttribute(name = "ID", isNotEmpty = true, errorInfo = "ID 不能为空", maxLength = 32)
	@Schema(description = "ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("ID")
	private String id;
	/**
	 * 申报单位
	 */
	@Length(max = 32, message = "申报单位 不能超过32 个字符")
	@ExcelAttribute(name = "申报单位", maxLength = 32)
	@Schema(description = "申报单位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报单位")
	private String declareUnit;
	/**
	 * 申报月份（YYYYMM）
	 */
	@NotBlank(message = "申报月份（YYYYMM） 不能为空")
	@Length(max = 6, message = "申报月份（YYYYMM） 不能超过6 个字符")
	@ExcelAttribute(name = "申报月份（YYYYMM）", isNotEmpty = true, errorInfo = "申报月份（YYYYMM） 不能为空", maxLength = 6)
	@Schema(description = "申报月份（YYYYMM）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份（YYYYMM）")
	private String declareMonth;
	/**
	 * 员工姓名
	 */
	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 32, message = "身份证号 不能超过32 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 32)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 年终奖
	 */
	@ExcelAttribute(name = "年终奖")
	@Schema(description = "年终奖")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖")
	private BigDecimal annualBonus;
	/**
	 * 年终奖单独扣税应缴税额
	 */
	@ExcelAttribute(name = "年终奖单独扣税应缴税额")
	@Schema(description = "年终奖单独扣税应缴税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖单独扣税应缴税额")
	private BigDecimal bonusTax;
	/**
	 * 项目id
	 */
	@Length(max = 32, message = "项目id 不能超过32 个字符")
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Schema(description = "项目id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
	private String deptId;
	/**
	 * 项目编码
	 */
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 单位id
	 */
	@Length(max = 32, message = "单位id 不能超过32 个字符")
	@ExcelAttribute(name = "单位id", maxLength = 32)
	@Schema(description = "单位id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位id")
	private String unitId;
	/**
	 * 单位编码
	 */
	@Length(max = 50, message = "单位编码 不能超过50 个字符")
	@ExcelAttribute(name = "单位编码", maxLength = 50)
	@Schema(description = "单位编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位编码")
	private String unitNo;

}
