/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.MTitleConfig;
import com.yifu.cloud.plus.v1.yifu.salary.service.MTitleConfigService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.MTitleConfigSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 原表表头与配置关联表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/mtitleconfig")
@Tag(name = "原表表头与配置关联表管理")
public class MTitleConfigController {

	private final MTitleConfigService mTitleConfigService;


	/**
	 * 简单分页查询
	 *
	 * @param page         分页对象
	 * @param mTitleConfig 原表表头与配置关联表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<MTitleConfig>> getMTitleConfigPage(Page<MTitleConfig> page, MTitleConfigSearchVo mTitleConfig) {
		return new R<>(mTitleConfigService.getMTitleConfigPage(page, mTitleConfig));
	}

	/**
	 * 通过id查询原表表头与配置关联表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('salary_mtitleconfig_get')")
	@GetMapping("/{id}")
	public R<MTitleConfig> getById(@PathVariable("id") String id) {
		return R.ok(mTitleConfigService.getById(id));
	}

	/**
	 * 新增原表表头与配置关联表
	 *
	 * @param mTitleConfig 原表表头与配置关联表
	 * @return R
	 */
	@Operation(summary = "新增原表表头与配置关联表", description = "新增原表表头与配置关联表：hasPermission('salary_mtitleconfig_add')")
	@SysLog("新增原表表头与配置关联表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('salary_mtitleconfig_add')")
	public R<Boolean> save(@RequestBody MTitleConfig mTitleConfig) {
		return R.ok(mTitleConfigService.save(mTitleConfig));
	}

	/**
	 * 修改原表表头与配置关联表
	 *
	 * @param mTitleConfig 原表表头与配置关联表
	 * @return R
	 */
	@Operation(summary = "修改原表表头与配置关联表", description = "修改原表表头与配置关联表：hasPermission('salary_mtitleconfig_edit')")
	@SysLog("修改原表表头与配置关联表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('salary_mtitleconfig_edit')")
	public R<Boolean> updateById(@RequestBody MTitleConfig mTitleConfig) {
		return R.ok(mTitleConfigService.updateById(mTitleConfig));
	}

	/**
	 * 通过id删除原表表头与配置关联表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除原表表头与配置关联表", description = "通过id删除原表表头与配置关联表：hasPermission('salary_mtitleconfig_del')")
	@SysLog("通过id删除原表表头与配置关联表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('salary_mtitleconfig_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(mTitleConfigService.removeById(id));
	}

}
