package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.SysMessageSalaryTemp;
import com.yifu.cloud.plus.v1.yifu.salary.service.SysMessageSalaryTempService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * 最低工资提醒-临时人员连续购买最低工资次数
 *
 * @author wangan
 * @date 2020-12-17 09:23:30
 */
@RestController
@AllArgsConstructor
@RequestMapping("/sysmessagesalarytemp")
@Tag(name = "最低工资提醒-临时人员连续购买最低工资次数")
public class SysMessageSalaryTempController {

  private final SysMessageSalaryTempService sysMessageSalaryTempService;

  /**
   * 简单分页查询
   * @param page 分页对象
   * @param sysMessageSalaryTemp 最低工资提醒-临时人员连续购买最低工资次数
   * @return
   */
  @Operation(description = "简单分页查询")
  @GetMapping("/page")
  public R<IPage<SysMessageSalaryTemp>> getSysMessageSalaryTempPage(Page<SysMessageSalaryTemp> page, SysMessageSalaryTemp sysMessageSalaryTemp) {
    return  new R<>(sysMessageSalaryTempService.getSysMessageSalaryTempPage(page,sysMessageSalaryTemp));
  }


  /**
   * 通过id查询单条记录
   * @param id
   * @return R
   */
  @Operation(description = "id查询")
  @GetMapping("/{id}")
  public R<SysMessageSalaryTemp> getById(@PathVariable("id") String id){
    return new R<>(sysMessageSalaryTempService.getById(id));
  }

  /**
   * 新增记录
   * @param sysMessageSalaryTemp
   * @return R
   */
  @Operation(description = "新增(wxhr:sysmessagesalarytemp_add)")
  @PostMapping
  @PreAuthorize("@pms.hasPermission('wxhr:sysmessagesalarytemp_add')")
  public R<Boolean> save(@Valid @RequestBody SysMessageSalaryTemp sysMessageSalaryTemp){
    return new R<>(sysMessageSalaryTempService.save(sysMessageSalaryTemp));
  }

  /**
   * 修改记录
   * @param sysMessageSalaryTemp
   * @return R
   */
  @Operation(description = "修改(wxhr:sysmessagesalarytemp_edit)")
  @SysLog("修改最低工资提醒-临时人员连续购买最低工资次数")
  @PutMapping
  @PreAuthorize("@pms.hasPermission('wxhr:sysmessagesalarytemp_edit')")
  public R<Boolean> update(@RequestBody SysMessageSalaryTemp sysMessageSalaryTemp){
    return new R<>(sysMessageSalaryTempService.updateById(sysMessageSalaryTemp));
  }

  /**
   * 通过id删除一条记录
   * @param id
   * @return R
   */
  @Operation(description = "删除(wxhr:sysmessagesalarytemp_del)")
  @SysLog("删除最低工资提醒-临时人员连续购买最低工资次数")
  @DeleteMapping("/{id}")
  @PreAuthorize("@pms.hasPermission('wxhr:sysmessagesalarytemp_del')")
  public R<Boolean> removeById(@PathVariable String id){
    return new R<>(sysMessageSalaryTempService.removeById(id));
  }

}
