package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.THaveSalaryNosocial;
import com.yifu.cloud.plus.v1.yifu.salary.service.THaveSalaryNosocialService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.THaveSalaryNosocialSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;


/**
 * @Author fxj
 * @Description 有资没有社保(首页提醒定时任务）
 * @Date 17:02 2022/8/23
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/thavesalarynosocial")
@Tag(name = "有工资没有社保(首页提醒定时任务）")
@Slf4j
public class THaveSalaryNosocialController {

    private final THaveSalaryNosocialService tHaveSalaryNosocialService;
	private final MenuUtil menuUtil;
    /**
     * 简单分页查询
     *
     * @param page                分页对象
     * @param tHaveSalaryNosocial 有资没有社保(首页提醒定时任务）
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<THaveSalaryNosocial>> getTHaveSalaryNosocialPage(Page<THaveSalaryNosocial> page, THaveSalaryNosocial tHaveSalaryNosocial) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tHaveSalaryNosocial);
		if (Common.isNotNull(tHaveSalaryNosocial.getAuthSql()) && tHaveSalaryNosocial.getAuthSql().contains(CommonConstants.A_DEPT_ID)) {
			tHaveSalaryNosocial.setAuthSql(tHaveSalaryNosocial.getAuthSql().replace(CommonConstants.A_DEPT_ID, "a.SETTLE_DOMAIN_ID"));
		}
        return new R<>(tHaveSalaryNosocialService.getTHaveSalaryNosocialPage(page, tHaveSalaryNosocial));
    }


    /**
     * 简单分页查询
     *
     * @param page                分页对象
     * @param tHaveSalaryNosocial 有资没有社保(首页提醒定时任务）
     * @return
     */
    @Operation(description = "有工资无社保处理简单分页查询")
    @GetMapping("/handle/page")
    public R<IPage<THaveSalaryNosocial>> getTHaveSalaryNosocialHandelPage(Page<THaveSalaryNosocial> page, THaveSalaryNosocial tHaveSalaryNosocial) {
        return new R<>(tHaveSalaryNosocialService.getTHaveSalaryNosocialHandelPage(page, tHaveSalaryNosocial));
    }


    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "id查询")
    @GetMapping("/{id}")
    public R<THaveSalaryNosocial> getById(@PathVariable("id") String id) {
        return new R<>(tHaveSalaryNosocialService.getById(id));
    }

    /**
     * 新增记录
     *
     * @param tHaveSalaryNosocial
     * @return R
     */
    @Operation(description = "新增(wxhr:thavesalarynosocial_add)")
    @PostMapping
    @PreAuthorize("@pms.hasPermission('wxhr:thavesalarynosocial_add')")
    public R<Object> save(@Valid @RequestBody THaveSalaryNosocial tHaveSalaryNosocial) {
        return new R<>(tHaveSalaryNosocialService.save(tHaveSalaryNosocial));
    }

    /**
     * 修改记录
     *
     * @param tHaveSalaryNosocial
     * @return R
     */
    @Operation(description = "修改(wxhr:thavesalarynosocial_edit)")
    @SysLog("修改有资没有社保(首页提醒定时任务）")
    @PutMapping
    @PreAuthorize("@pms.hasPermission('wxhr:thavesalarynosocial_edit')")
    public R<Object> update(@RequestBody THaveSalaryNosocial tHaveSalaryNosocial) {
        return new R<>(tHaveSalaryNosocialService.updateById(tHaveSalaryNosocial));
    }

    /**
     * 通过id删除一条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "删除(wxhr:thavesalarynosocial_del)")
    @SysLog("删除有资没有社保(首页提醒定时任务）")
    @DeleteMapping("/{id}")
    @PreAuthorize("@pms.hasPermission('wxhr:thavesalarynosocial_del')")
    public R<Object> removeById(@PathVariable String id) {
        return new R<>(tHaveSalaryNosocialService.removeById(id));
    }

	/**
	 * @Author fxj
	 * @Description 有工资无社保消息提醒导出
	 * @Date 15:28 2022/8/17
	 * @Param
	 * @return
	**/
	@SysLog("有工资无社保消息提醒导出")
	@Operation(description = "有工资无社保消息提醒导出")
	@PostMapping("/export")
	public void export(HttpServletResponse response,
					   @RequestBody THaveSalaryNosocialSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		if (Common.isNotNull(searchVo.getAuthSql()) && searchVo.getAuthSql().contains(CommonConstants.A_DEPT_ID)) {
			searchVo.setAuthSql(searchVo.getAuthSql().replace(CommonConstants.A_DEPT_ID, "a.SETTLE_DOMAIN_ID"));
		}
		tHaveSalaryNosocialService.listExport(response,searchVo);
	}

	/**
	 * @Author fxj
	 * @Description  只有创建人为自己才能反馈
	 * @Date 17:15 2022/8/17
	 * @Param
	 * @return
	**/
	@SysLog("有工资无社保消息提醒反馈")
	@Operation(description = "有工资无社保消息提醒反馈")
	@PostMapping("/feedback")
	public R<String> feedback(@RequestParam(name = "id",required = true) String id,
							  @RequestParam(name = "reasonType",required = true) Integer reasonType,
							  @RequestParam(name = "feedBack",required = true) String feedBack) {
		return tHaveSalaryNosocialService.feedback(reasonType,id,feedBack);
	}


    /**
     * @Author fxj
     * @Description 有资没有社保(首页提醒定时任务 每月1号 6点）
     * @Date 17:16 2022/8/17
     * @Param
     * @return
    **/
    @Inner
    @PostMapping("/inner/generate")
    public void generate() {
        String salaryMonth = DateUtil.addMonth(-1);
        tHaveSalaryNosocialService.generate(salaryMonth);
    }

}
