/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ResultConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.redis.RedisDistributedLock;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TQuestionFeedbackInfo;
import com.yifu.cloud.plus.v1.yifu.salary.service.TQuestionFeedbackInfoService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TQuestionFeedbackInfoSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @author fxj
 * @date 2024-12-18 15:39:57
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tquestionfeedbackinfo")
@Tag(name = "管理")
public class TQuestionFeedbackInfoController {

	private final TQuestionFeedbackInfoService tQuestionFeedbackInfoService;


	/**
	 * 简单分页查询
	 *
	 * @param page                  分页对象
	 * @param tQuestionFeedbackInfo
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TQuestionFeedbackInfo>> getTQuestionFeedbackInfoPage(Page<TQuestionFeedbackInfo> page, TQuestionFeedbackInfoSearchVo tQuestionFeedbackInfo) {
		return new R<>(tQuestionFeedbackInfoService.getTQuestionFeedbackInfoPage(page, tQuestionFeedbackInfo));
	}

	/**
	 * 不分页查询
	 *
	 * @param tQuestionFeedbackInfo
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('demo_tquestionfeedbackinfo_get')" )
	public R<List<TQuestionFeedbackInfo>> getTQuestionFeedbackInfoNoPage(@RequestBody TQuestionFeedbackInfoSearchVo tQuestionFeedbackInfo) {
		return R.ok(tQuestionFeedbackInfoService.noPageDiy(tQuestionFeedbackInfo));
	}

	/**
	 * 通过id查询
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tquestionfeedbackinfo_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('demo_tquestionfeedbackinfo_get')")
	public R<TQuestionFeedbackInfo> getById(@PathVariable("id") String id) {
		return R.ok(tQuestionFeedbackInfoService.getById(id));
	}

	/**
	 * 新增
	 *
	 * @param tQuestionFeedbackInfo
	 * @return R
	 */
	@Operation(summary = "新增", description = "新增")
	@SysLog("新增")
	@PostMapping("/add")
	public R<Boolean> save(@RequestBody TQuestionFeedbackInfo tQuestionFeedbackInfo) {
		String key = CacheConstants.QUESTION_FEEDBACK_LIMIT + CommonConstants.DOWN_LINE_STRING + "questionFeedBackFlag";
		String requestId;
		try {
			requestId = RedisDistributedLock.getLock(key,"10");
		} catch (Exception e) {
			throw new RuntimeException(ResultConstants.NO_GETLOCK_DATA+CommonConstants.DOWN_LINE_STRING+e.getMessage());
		}
		try {
			if (Common.isNotNull(requestId)) {
				if (Common.isNotNull(tQuestionFeedbackInfo.getQuestion()) && tQuestionFeedbackInfo.getQuestion().length() > 200){
					return R.failed("你遇到的问题请控制在200字以内！");
				}
				return tQuestionFeedbackInfoService.saveAsso(tQuestionFeedbackInfo);
			} else {
				return R.failed(ResultConstants.NO_GETLOCK_DATA);
			}
		}finally {
			//主动释放锁
			RedisDistributedLock.unlock(key, requestId);
		}


	}

	/**
	 * 修改
	 *
	 * @param tQuestionFeedbackInfo
	 * @return R
	 */
	@Operation(summary = "修改", description = "修改：hasPermission('demo_tquestionfeedbackinfo_edit')")
	@SysLog("修改")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('demo_tquestionfeedbackinfo_edit')")
	public R<Boolean> updateById(@RequestBody TQuestionFeedbackInfo tQuestionFeedbackInfo) {
		return R.ok(tQuestionFeedbackInfoService.updateById(tQuestionFeedbackInfo));
	}

	/**
	 * 通过id删除
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除", description = "通过id删除：hasPermission('demo_tquestionfeedbackinfo_del')")
	@SysLog("通过id删除")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('demo_tquestionfeedbackinfo_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tQuestionFeedbackInfoService.removeById(id));
	}

	/**
	 * 批量导入
	 *
	 * @author fxj
	 * @date 2024-12-18 15:39:57
	 **/
	@SneakyThrows
	@Operation(description = "批量新增 hasPermission('demo_tquestionfeedbackinfo-batch-import')")
	@SysLog("批量新增")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('demo_tquestionfeedbackinfo-batch-import')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return tQuestionFeedbackInfoService.importDiy(file.getInputStream());
	}

	/**
	 * 批量导出
	 *
	 * @author fxj
	 * @date 2024-12-18 15:39:57
	 **/
	@Operation(description = "导出 hasPermission('demo_tquestionfeedbackinfo-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('demo_tquestionfeedbackinfo-export')")
	public void export(HttpServletResponse response, @RequestBody TQuestionFeedbackInfoSearchVo searchVo) {
		tQuestionFeedbackInfoService.listExport(response, searchVo);
	}
}
