/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardIssue;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardOriginal;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryOriginalExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryOriginalSearchVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardIssueExportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 薪资原表识别导入
 *
 * @author hgw
 * @date 2024-4-2 11:57:29
 */
@Mapper
public interface TSalaryStandardOriginalMapper extends BaseMapper<TSalaryStandardOriginal> {
	/**
	 * 薪资原表识别导入-分页
	 */
	IPage<TSalaryStandardOriginal> getTSalaryStandardOriginalPage(Page<TSalaryStandardOriginal> page
			, @Param("tSalaryStandardOriginal") TSalaryStandardOriginal tSalaryStandardOriginal);
	/**
	 * 薪资原表识别导入-分页
	 */
	List<TSalaryStandardOriginal> getTSalaryStandardOriginalList(
			@Param("tSalaryStandardOriginal") TSalaryStandardOriginal tSalaryStandardOriginal);

	/**
	 * 特殊身份证允许识别为数据行
	 */
	List<String> getSpecialIdCardList();

	List<TSalaryOriginalExportVo> getTSalaryOriginalExportVoList(@Param("tSalaryStandardOriginal") TSalaryOriginalSearchVo tSalaryStandardOriginal
			, @Param("idsStr") List<String> idsStr);

	int exportListCount(@Param("tSalaryStandardOriginal") TSalaryOriginalSearchVo tSalaryStandardOriginal
			, @Param("idsStr") List<String> idsStr);

}
