/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsDeclarer;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsDeclarerSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 申报对象表
 *
 * @author huyc
 * @date 2022-08-11 10:56:10
 */
public interface TStatisticsDeclarerService extends IService<TStatisticsDeclarer> {
    /**
     * 申报对象表简单分页查询
     * @param tStatisticsDeclarer 申报对象表
     * @return
     */
    IPage<TStatisticsDeclarer> getTStatisticsDeclarerPage(Page<TStatisticsDeclarer> page, TStatisticsDeclarerSearchVo tStatisticsDeclarer);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TStatisticsDeclarerSearchVo searchVo);

    List<TStatisticsDeclarer> noPageDiy(TStatisticsDeclarerSearchVo searchVo);

	/**
	 * 不申报标识标记
	 * @param id
	 * @param isDeclare 是否申报
	 * @param undeclareReason 不申报原因
	 * @return
	 */
	R updateFlagById(String id, String isDeclare, String undeclareReason);

	/**
	 * @param
	 * @Description: 生成申报人员
	 * @return
	 **/
	R doStatisticsTaxDeclarer();
}
