/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.salary.entity.MTitleConfig;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.MTitleConfigMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.MTitleConfigService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.MTitleConfigSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

/**
 * 原表表头与配置关联表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Log4j2
@Service
public class MTitleConfigServiceImpl extends ServiceImpl<MTitleConfigMapper, MTitleConfig> implements MTitleConfigService {
	/**
	 * 原表表头与配置关联表简单分页查询
	 *
	 * @param mTitleConfig 原表表头与配置关联表
	 * @return
	 */
	@Override
	public IPage<MTitleConfig> getMTitleConfigPage(Page<MTitleConfig> page, MTitleConfigSearchVo mTitleConfig) {
		return baseMapper.getMTitleConfigPage(page, mTitleConfig);
	}


}
