/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardOriginalDetail;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryStandardOriginalDetailMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardOriginalDetailService;
import lombok.AllArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 薪资原表识别
 * @author hgw
 * @date 2024-4-2 17:20:46
 */
@Log4j2
@Service
@AllArgsConstructor
public class TSalaryStandardOriginalDetailServiceImpl extends ServiceImpl<TSalaryStandardOriginalDetailMapper, TSalaryStandardOriginalDetail>
		implements TSalaryStandardOriginalDetailService {

	/**
	 * @Description: 分页查询
	 * @Author: hgw
	 * @Date: 2024/4/2 17:19
	 * @return:
	 **/
	@Override
	public IPage<TSalaryStandardOriginalDetail> getTSalaryStandardOriginalPage(Page<TSalaryStandardOriginalDetail> page, TSalaryStandardOriginalDetail tSalaryStandardOriginalDetail) {
		return baseMapper.getTSalaryStandardOriginalDetailPage(page, tSalaryStandardOriginalDetail);
	}

	@Override
	public List<TSalaryStandardOriginalDetail> getTSalaryStandardOriginalDetailByOrgId(String originalId) {
		return baseMapper.getTSalaryStandardOriginalDetailByOrgId(originalId);
	}

	/**
	 * @Description: 删除关系
	 * @Author: hgw
	 * @Date: 2024/4/3 15:42
	 * @return: int
	 **/
	@Override
	public int deleteByOrgId(String originalId) {
		return baseMapper.deleteByOrgId(originalId);
	}
}
