/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 社保士兵与税友切换表
 *
 * @author hgw
 * @date 2024-12-12 09:40:56
 */
@Data
@TableName("t_social_freind_set")
@Schema(description = "社保士兵与税友切换表")
public class TSocialFreindSet {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 类型：0社保士兵 1税友
	 */
	@ExcelAttribute(name = "类型：0社保士兵 1税友", isNotEmpty = true, errorInfo = "类型：0社保士兵 1税友不能为空")
	@NotBlank(message = "类型：0社保士兵 1税友不能为空")
	@ExcelProperty("类型：0社保士兵 1税友")
	@Schema(description = "类型：0社保士兵 1税友")
	private Integer type;

}
