/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 自动化实缴记录表
 *
 * @author fxj
 * @date 2024-05-24 10:56:42
 */
@Data
public class TAutoPaymentDetailVo extends RowIndex implements Serializable {

	/**
	 * 是否重新办理 0 是 1 否
	 */
	@ExcelAttribute(name = "是否重新办理", maxLength = 1,readConverterExp = "0=是,1=否",isNotEmpty = true)
	@Schema(description = "是否重新办理 0 是 1 否")
	@ExcelProperty("是否重新办理")
	private String repeatHandleFlag;
	/**
	 * 姓名
	 */
	@Length(max = 32, message = "姓名 不能超过32 个字符")
	@ExcelAttribute(name = "姓名", maxLength = 32,isNotEmpty = true)
	@Schema(description = "姓名")
	@ExcelProperty("姓名")
	private String empName;

	/**
	 * 证件号码
	 */
	@ExcelAttribute(name = "证件号码", maxLength = 50,isNotEmpty = true)
	@Schema(description = "证件号码")
	@ExcelProperty("证件号码")
	private String certNum;

	/**
	 * 社保户
	 */
	@Length(max = 100, message = "社保户 不能超过100 个字符")
	@ExcelAttribute(name = "社保户", maxLength = 100,isNotEmpty = true)
	@Schema(description = "社保户")
	@ExcelProperty("社保户")
	private String socialSecurityAccount;
}
