/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 预估费用导出Vo
 *
 * @author hgw
 * @date 2022-7-28 15:20:24
 */
@Data
@Schema(description = "预估费用导出Vo")
public class TForecastLibraryExportVo {

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;

	@ExcelAttribute(name = "员工编码", maxLength = 32)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码")
	private String empNo;

	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;

	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;

	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "单位养老费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老费用")
	private BigDecimal unitPensionFee;

	@ExcelAttribute(name = "单位医疗费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗费用")
	private BigDecimal unitMedicalFee;

	@ExcelAttribute(name = "单位失业费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业费用")
	private BigDecimal unitUnemploymentFee;

	@ExcelAttribute(name = "单位工伤费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤费用")
	private BigDecimal unitWorkInjuryFee;

	@ExcelAttribute(name = "单位生育费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育费用")
	private BigDecimal unitBirthFee;

	@ExcelAttribute(name = "单位大病救助")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病救助")
	private BigDecimal unitBitailmentFee;

	@ExcelAttribute(name = "个人养老费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老费用")
	private BigDecimal personalPensionFee;

	@ExcelAttribute(name = "个人医疗费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗费用")
	private BigDecimal personalMedicalFee;

	@ExcelAttribute(name = "个人失业费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业费用")
	private BigDecimal personalUnemploymentFee;

	@ExcelAttribute(name = "个人大病费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病费用")
	private BigDecimal personalBigailmentFee;

	@ExcelAttribute(name = "社保缴纳月份", maxLength = 6)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳月份")
	private String socialPayMonth;

	@ExcelAttribute(name = "社保生成月份", maxLength = 6)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保生成月份")
	private String socialCreateMonth;

	@ExcelAttribute(name = "公积金缴纳月份", maxLength = 6)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳月份")
	private String providentPayMonth;

	@ExcelAttribute(name = "公积金生成月份", maxLength = 6)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金生成月份")
	private String providentCreateMonth;

	@ExcelAttribute(name = "单位社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保合计")
	private BigDecimal unitSocialSum;

	@ExcelAttribute(name = "单位公积金合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金合计")
	private BigDecimal unitFundSum;

	@ExcelAttribute(name = "个人社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保合计")
	private BigDecimal personalSocialSum;

	@ExcelAttribute(name = "个人公积金合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金合计")
	private BigDecimal personalFundSum;

	@ExcelAttribute(name = "费用合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("费用合计")
	private BigDecimal sumAll;

	@ExcelAttribute(name = "公积金缴纳地-省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-省")
	private String fundProvince;

	@ExcelAttribute(name = "公积金缴纳地-市", isArea = true, parentField = "fundProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-市")
	private String fundCity;

	@ExcelAttribute(name = "公积金缴纳地-县", isArea = true, parentField = "fundCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-县")
	private String fundTown;

	@ExcelAttribute(name = "社保缴纳地-省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-省")
	private String socialProvince;

	@ExcelAttribute(name = "社保缴纳地-市", isArea = true, parentField = "socialProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-市")
	private String socialCity;

	@ExcelAttribute(name = "社保缴纳地-县", isArea = true, parentField = "socialCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-县")
	private String socialTown;

	@ExcelAttribute(name = "单位养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数")
	private BigDecimal unitPensionBase;

	@ExcelAttribute(name = "单位医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数")
	private BigDecimal unitMedicalBase;

	@ExcelAttribute(name = "单位失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数")
	private BigDecimal unitUnemploymentBase;

	@ExcelAttribute(name = "单位工伤基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤基数")
	private BigDecimal unitInjuryBase;

	@ExcelAttribute(name = "单位生育基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育基数")
	private BigDecimal unitBirthBase;

	@ExcelAttribute(name = "个人养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老基数")
	private BigDecimal personalPensionBase;

	@ExcelAttribute(name = "个人医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗基数")
	private BigDecimal personalMedicalBase;

	@ExcelAttribute(name = "个人失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业基数")
	private BigDecimal personalUnemploymentBase;

	@ExcelAttribute(name = "个人大病基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病基数")
	private BigDecimal personalBigailmentBase;

	@ExcelAttribute(name = "单位大病基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病基数")
	private BigDecimal unitBigailmentBase;

	@ExcelAttribute(name = "单位养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例")
	private BigDecimal unitPersionPro;

	@ExcelAttribute(name = "单位医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例")
	private BigDecimal unitMedicalPro;

	@ExcelAttribute(name = "单位失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例")
	private BigDecimal unitUnemploymentPro;

	@ExcelAttribute(name = "单位工伤比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例")
	private BigDecimal unitInjuryPro;

	@ExcelAttribute(name = "单位生育比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例")
	private BigDecimal unitBirthPro;

	@ExcelAttribute(name = "个人养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例")
	private BigDecimal personalPersionPro;

	@ExcelAttribute(name = "个人医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例")
	private BigDecimal personalMedicalPro;

	@ExcelAttribute(name = "个人失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例")
	private BigDecimal personalUnemploymentPro;

	@ExcelAttribute(name = "个人大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例")
	private BigDecimal personalBigailmentPro;

	@ExcelAttribute(name = "单位大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病比例")
	private BigDecimal unitBigailmentPro;

	@ExcelAttribute(name = "单位公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金基数")
	private BigDecimal unitFundBase;

	@ExcelAttribute(name = "个人公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金基数")
	private BigDecimal personalFundBase;

	@ExcelAttribute(name = "单位公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例")
	private BigDecimal unitFundProp;

	@ExcelAttribute(name = "个人公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金比例")
	private BigDecimal personalFundProp;

	@ExcelAttribute(name = "同步状态", readConverterExp = "0=未同步,1=已同步")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("同步状态")
	private String dataPush;

	@DateTimeFormat("yyyy-MM-dd HH:mm:ss")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据生成时间")
	private LocalDateTime createTime;

	@ExcelAttribute(name = "数据类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据类型")
	private String diffType;

	@ExcelAttribute(name = "类型", readConverterExp = "0=社保,1=公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型")
	private String dataType;

}
