package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.social.util.BigDecimalConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName TPaymentHeFeiVo
 * @Description 税务社保明细
 * @author huyc
 * @date 2024-5-9 10:35:22
 */
@Data
public class TPaymentTaxSocialVo extends RowIndex implements Serializable {
    /**
     * 员工姓名
     */
    @Length(max = 20, message = "姓名不能超过20个字符")
    @ExcelAttribute(name = "姓名", maxLength = 20,isNotEmpty = true)
	@Schema(description = "姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "姓名")
    private String empName;
    /**
     * 证件类型
     */
    @Length(max = 30, message = "证件类型不能超过30个字符")
    @ExcelAttribute(name = "证件类型",  maxLength = 30)
	@Schema(description = "证件类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "证件类型")
    private String cardType;

    /**
     * 证件号码
     */
    @Length(max = 50, message = "不能超过50个字符")
    @ExcelAttribute(name = "证件号码", isNotEmpty = true, maxLength = 50,errorInfo = "证件号码字段不可为空！")
	@Schema(description = "证件号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "证件号码")
    private String empIdcard;

	/**
	 * 缴费工资
	 */
	@ExcelAttribute(name = "缴费工资", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "缴费工资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "缴费工资", converter = BigDecimalConverter.class)
	private BigDecimal paymentSalary;

	/**
	 * 缴费基数
	 */
	@ExcelAttribute(name = "缴费基数", isFloat = true,max = "999999999.99")
	@Schema(description = "缴费基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "缴费基数", converter = BigDecimalConverter.class)
	private BigDecimal paymentSet;

	/**
	 * 费率
	 */
	@ExcelAttribute(name = "费率")
	@Schema(description = "费率")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "费率")
	private String paymentPer;

	/**
	 * 应缴费额
	 */
	@ExcelAttribute(name = "应缴费额", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "应缴费额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "应缴费额", converter = BigDecimalConverter.class)
	private BigDecimal paymentMoney;

	/**
	 * 人员编号（不导入）
	 */
	@ExcelAttribute(name = "人员编号")
	@Schema(description = "人员编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "人员编号")
	private String empNo;

	/**
	 * 险种
	 */
	@ExcelAttribute(name = "险种", isNotEmpty = true, errorInfo = "险种不可为空", maxLength = 20)
	@Schema(description = "险种")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "险种")
	private String riskType;

    /**
     * 社保缴纳地
     */
    @Length(max = 50, message = "社保缴纳地不能超过50个字符")
    @ExcelAttribute(name = "社保缴纳地", isNotEmpty = true, errorInfo = "社保缴纳地不可为空", maxLength = 50)
	@Schema(description = "社保缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地")
    private String socialPayAddr;

    /**
     * 社保缴纳地-省
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-省",  maxLength = 32, isDataId = true, isArea = true, parentField = "")
	@Schema(description = "社保缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-省")
    private Integer socialProvince;
    /**
     * 社保缴纳地-市
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-市",  maxLength = 32, isDataId = true, isArea = true, parentField = "socialProvince")
	@Schema(description = "社保缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-市")
    private Integer socialCity;
    /**
     * 社保缴纳地-县
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-县",  maxLength = 32, isDataId = true, isArea = true, parentField = "socialCity")
	@Schema(description = "社保缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-县")
    private Integer socialTown;
    /**
     * 社保缴纳月份
     */
    @ExcelAttribute(name = "社保缴纳月份", isNotEmpty = true, errorInfo = "社保缴纳月份不可为空", maxLength = 6, min = 6, isInteger = true)
	@Schema(description = "社保缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳月份")
    private String socialPayMonth;
    /**
     * 社保生成月份
     */
    @Length(max = 6, message = "社保生成月份不能超过6个字符")
    @ExcelAttribute(name = "社保生成月份", isNotEmpty = true, errorInfo = "社保生成月份不可为空",  maxLength = 6, min = 6,isInteger = true)
	@Schema(description = "社保生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保生成月份")
    private String socialCreateMonth;

	/**
	 * 社保户
	 */
	@Length(max = 32, message = "社保户不能超过32个字符")
	@ExcelAttribute(name = "社保户", maxLength = 32)
	@Schema(description = "社保户")
	@ExcelProperty(value = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String socialHousehold;

}
