package com.yifu.cloud.plus.v1.yifu.social.concurrent.threadpool;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description: 线程池配置添加到spring管理，并初始化线程池名称
 * @author: wangweiguo
 * @date: 2021/6/30
 */

@Configuration
public class YFThreadPoolConfig {


    @Bean(name = "yfSocialImportThreadPoolExecutor")
    YFSocialImportThreadPoolExecutor yfSocialImportThreadPoolExecutor(@Qualifier("yfThreadFactory") YFThreadFactory yfThreadFactory) {
        return new YFSocialImportThreadPoolExecutor(yfThreadFactory);
    }

    @Bean(name = "yfThreadFactory")
    YFThreadFactory yfThreadFactory() {
        return new YFThreadFactory("social_import");
    }
}
