package com.yifu.cloud.plus.v1.yifu.social.config;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.AbstractVerticalCellStyleStrategy;
import org.apache.poi.ss.usermodel.*;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CustomCellStyleThreeStrategy extends AbstractVerticalCellStyleStrategy {

	/**
	 * 操作列
	 */
	private List<Integer> columnIndexes;

	public CustomCellStyleThreeStrategy(List<Integer> columnIndexes ) {
		this.columnIndexes = columnIndexes;
	}


	@Override
	public void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
		super.setHeadCellStyle(cell, head, relativeRowIndex);
	}

	@Override
	protected WriteCellStyle headCellStyle(Head head) {

		// 获取样式实例
		WriteCellStyle headWriteCellStyle = new WriteCellStyle();
		// 获取字体实例
		WriteFont headWriteFont = new WriteFont();
		// 设置字体样式
		headWriteFont.setFontName("宋体");
		// 设置字体大小
		headWriteFont.setFontHeightInPoints((short)12);
		// 边框
		headWriteFont.setBold(false);
		headWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
		headWriteCellStyle.setWriteFont(headWriteFont);
		return headWriteCellStyle;
	}

	@Override
	protected WriteCellStyle contentCellStyle(Head head) {

		// 获取样式实例
		WriteCellStyle headWriteCellStyle = new WriteCellStyle();
		// 获取字体实例
		WriteFont headWriteFont = new WriteFont();
		// 设置字体样式
		headWriteFont.setFontName("宋体");
		// 设置字体大小
		headWriteFont.setFontHeightInPoints((short)12);
		// 边框
		headWriteFont.setBold(false);
		headWriteCellStyle.setFillForegroundColor(IndexedColors.BLACK.getIndex());
		headWriteCellStyle.setWriteFont(headWriteFont);
		headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
		headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
		headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
		headWriteCellStyle.setBorderTop(BorderStyle.THIN);
		headWriteCellStyle.setBorderRight(BorderStyle.THIN);
		headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
		return headWriteCellStyle;
	}
}