package com.yifu.cloud.plus.v1.yifu.social.config;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CustomCellWriteWidthOneConfig extends AbstractColumnWidthStyleStrategy {


	@Override
	protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer integer, Boolean isHead) {
		boolean needSetWidth = isHead || !CollectionUtils.isEmpty(cellDataList);
		if (needSetWidth) {
			Sheet sheet = writeSheetHolder.getSheet();
			int columnIndex = cell.getColumnIndex();
			// 单元格文本长度大于45换行
			if (columnIndex == 3) {
				//要求将当前列的列宽设置为33英寸，理论值应该是33×256=8448，
				//但是这里的设值是8648，具体原因请看下面的计算逻辑
				sheet.setColumnWidth(0, 1000);
				sheet.setColumnWidth(2, 3500);
				sheet.setColumnWidth(3, 5000);
				sheet.setColumnWidth(4, 1000);
				sheet.setColumnWidth(6, 5000);
				sheet.setColumnWidth(7, 4700);
				sheet.setColumnWidth(9, 1000);
				sheet.setColumnWidth(10, 1000);
				sheet.setColumnWidth(11, 1000);
				sheet.setColumnWidth(12, 1000);
				sheet.setColumnWidth(13, 1000);
				sheet.setColumnWidth(14, 1800);
				sheet.setColumnWidth(15, 5000);
				sheet.setColumnWidth(16, 3200);
				sheet.setColumnWidth(17, 3000);
			}
		}
	}
}