/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAuditInfo;
import com.yifu.cloud.plus.v1.yifu.social.service.TAuditInfoService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAuditInfoSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tauditinfo" )
@Tag(name = "审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）管理")
public class TAuditInfoController {

    private final TAuditInfoService tAuditInfoService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tAuditInfo 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAuditInfo>> getTAuditInfoPage(Page<TAuditInfo> page, TAuditInfoSearchVo tAuditInfo) {
        return  new R<>(tAuditInfoService.getTAuditInfoPage(page,tAuditInfo));
    }
    /**
     * 不分页查询
     * @param tAuditInfo 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tauditinfo_get')" )
    public R<List<TAuditInfo>> getTAuditInfoNoPage(@RequestBody TAuditInfoSearchVo tAuditInfo) {
        return R.ok(tAuditInfoService.noPageDiy(tAuditInfo));
    }

    /**
     * 通过id查询审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tauditinfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tauditinfo_get')" )
    public R<TAuditInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tAuditInfoService.getById(id));
    }

    /**
     * 新增审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @param tAuditInfo 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @return R
     */
    @Operation(summary = "新增审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）", description = "新增审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）：hasPermission('demo_tauditinfo_add')")
    @SysLog("新增审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tauditinfo_add')" )
    public R<Boolean> save(@RequestBody TAuditInfo tAuditInfo) {
        return R.ok(tAuditInfoService.save(tAuditInfo));
    }

    /**
     * 修改审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @param tAuditInfo 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @return R
     */
    @Operation(summary = "修改审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）", description = "修改审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）：hasPermission('demo_tauditinfo_edit')")
    @SysLog("修改审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tauditinfo_edit')" )
    public R<Boolean> updateById(@RequestBody TAuditInfo tAuditInfo) {
        return R.ok(tAuditInfoService.updateById(tAuditInfo));
    }

    /**
     * 通过id删除审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）", description = "通过id删除审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）：hasPermission('demo_tauditinfo_del')")
    @SysLog("通过id删除审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tauditinfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAuditInfoService.removeById(id));
    }

    /**
	 * 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录） 批量导入
	 *
     * @author fxj
     * @date 2022-07-15 11:38:05
	 **/
    @SneakyThrows
    @Operation(description = "批量新增审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录） hasPermission('demo_tauditinfo-batch-import')")
    @SysLog("批量新增审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_tauditinfo-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return tAuditInfoService.importDiy(file.getInputStream());
    }

    /**
     * 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录） 批量导出
     * @author fxj
     * @date 2022-07-15 11:38:05
     **/
    @Operation(description = "导出审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录） hasPermission('demo_tauditinfo-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_tauditinfo-export')")
    public void export(HttpServletResponse response, @RequestBody TAuditInfoSearchVo searchVo) {
            tAuditInfoService.listExport(response,searchVo);
    }
}
