/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.util.RedisUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentInfoImportLogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 
 *
 * @author huyc
 * @date 2022-07-25 14:08:58
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tpaymentinfoimportlog" )
@Tag(name = "管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TPaymentInfoImportLogController {

    private final TPaymentInfoImportLogService tPaymentInfoImportLogService;

	private final RedisUtil redisUtil;

	@Operation(description = "导出社保导入日志")
	@GetMapping("/exportPaymentInfoLog")
	public String exportPaymentInfoLog() {
		YifuUser user = SecurityUtils.getUser();
		String key = user.getId() + CommonConstants.DOWN_LINE_STRING + CommonConstants.PAYMENT_SOCIAL_WAIT_EXPORT;
		String importRandom = (String) redisUtil.get(key);
		if (StringUtils.isNotBlank(importRandom)) {
			return importRandom;
		}
		return CommonConstants.ZERO_STRING;
	}

	/**
	 * @description: 清空社保导入日志表
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Void>
	 * @author: huyc
	 * @date: 2022/7/25
	 */
	@Inner
	@DeleteMapping("/inner/delPaymentInfoLog")
	public R<Void> delPaymentInfoLog() {
		boolean flag = tPaymentInfoImportLogService.remove(new QueryWrapper<>());
		if (flag) {
			return R.ok();
		} else {
			return R.failed("操作失败！");
		}
	}

}
