/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.OSSUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.social.config.SocialFriendConfig;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFriendBackLog;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TAttaInfoMapper;
import com.yifu.cloud.plus.v1.yifu.social.util.WordToImageUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


/**
 * 税友word文档离职证明
 *
 * @author hgw
 * @date 2025-5-14 18:24:58
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsocialfriendword")
@Tag(name = "税友word文档离职证明")
public class TSocialFriendWordController {

	@Operation(description = "生成新word")
	@GetMapping("/updateNewFileTest")
	@SysLog("生成新word")
	public R<String> updateNewFileTest() throws Exception{
		// 1：将劳动合同解除证明书.doc某些文字替换
		// 2：盖章
		// 3：生成新文件
		String inputPath = "D:/test126.docx";
		String outputPath = "D:/test126666.docx";
		String outputImagePath = "D:/document_with_seal.png"; // 可以从配置中获取
		return wordToImage(inputPath, outputPath, outputImagePath);
	}

	@Autowired
	private OSSUtil ossUtil;

	@Autowired
	private WordToImageUtil wordToImageUtil;

	@Autowired
	private TAttaInfoMapper attaInfoMapper;

	private final RestTemplate restTemplate;
	private final SocialFriendConfig socialFriendConfig;

	public R<String> wordToImage(String inputPath, String outputPath, String outputImagePath) throws Exception {
		String src = "1735185038602皖信.png";
		URL url = ossUtil.getObjectUrl(null, src);
		if (Common.isEmpty(url)) {
			throw new RuntimeException("获取印章图片失败");
		}
		try (InputStream imageStream = url.openStream()) {

			// 准备替换参数
			Map<String, String> replacements = new HashMap<>();
			replacements.put("empName", "张三丰");
			replacements.put("empSex", "女");
			replacements.put("empAge", "33");
			replacements.put("idCard", "340826199012121212");
			replacements.put("startDate", "2023年11月28日");
			replacements.put("leaveReason", "个人原因");
			replacements.put("leaveDate", "2025年01月20日");
			replacements.put("nowDate", DateUtil.formatDatePatten(new Date(), DateUtil.CHINA_PATTEN_YMD));

			// 离职证明模板
			String templateSrc = attaInfoMapper.getLeaveDocTemplate();
			URL templateUrl = null;
			if (Common.isNotNull(templateSrc)) {
				templateUrl = ossUtil.getObjectUrl(null, templateSrc);
			}
			if (templateUrl != null) {
				// 执行替换 + 插入印章
				TSocialFriendBackLog backLog = new TSocialFriendBackLog();
				backLog.setSocialId("test");
				backLog.setType(CommonConstants.EIGHT_INT);
				backLog.setCreateTime(LocalDateTime.now());
				String friendUrl = wordToImageUtil.replaceTextInWord(templateUrl.openStream()
						, replacements, imageStream, restTemplate, socialFriendConfig, backLog);
				return R.ok(friendUrl);
			}
		}
		return R.ok();
	}
}
