/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;


/**
 * 瓜子采集表单信息分类表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Data
@TableName("sys_out_emp_categorize_form_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子采集表单信息分类表")
public class SysOutEmpCategorizeFormInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	@Schema(description = "附属信息分类标识")
	private String fieldName;

	/**
	 * 分类名称
	 */
	@Length(max = 100, message = "分类名称不能超过100个字符")
	@Schema(description = "分类名称")
	private String name;
	/**
	 * 排序
	 */
	@Schema(description = "排序")
	private Integer sort;
	/**
	 * 分组类型（1：单个信息组，2：多个信息组）
	 */
	@Length(max = 1, message = "分组类型（1：单个信息组，2：多个信息组）不能超过1个字符")
	@Schema(description = "分组类型（1：单个信息组，2：多个信息组）")
	private String groupType;
	/**
	 * C端是否可见（0：是，1：否）
	 */
	@Length(max = 1, message = "C端是否可见（0：是，1：否）不能超过1个字符")
	@Schema(description = "C端是否可见（0：是，1：否）")
	private String isLookToc;
	/**
	 * 删除标记
	 */
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

}
