/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;


/**
 * 外部字典与皖信字典的映射关系表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Data
@TableName("sys_out_rel_dict")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "外部字典与皖信字典的映射关系表")
public class SysOutRelDict extends BaseEntity {

	/**
	 * 字典ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "字典ID")
	private Long id;
	/**
	 * 外部端字典标识
	 */
	@Length(max = 128, message = "外部端字典标识不能超过128个字符")
	@Schema(description = "外部端字典标识")
	private String clientType;
	/**
	 * 对照皖信字典项标识
	 */
	@Length(max = 128, message = "对照皖信字典项标识不能超过128个字符")
	@Schema(description = "对照皖信字典项标识")
	private String sysDictType;

	/**
	 * 外部端标识（gz：瓜子）
	 */
	@Length(max = 32, message = "外部端标识（gz：瓜子）不能超过32个字符")
	@Schema(description = "外部端标识（gz：瓜子）")
	private String clientId;

}
