
package com.yifu.cloud.plus.v1.yifu.admin.api.vo;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysMenu;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
public class MenuTree extends TreeNode {
    private String id;
	private String icon;
	private String name;
	private String parentId;
	private boolean spread = false;
	private String path;
	private String authority;
	private String redirect;
	private String keepAlive;
	private String code;
	private String type;
	private String label;
	private Integer sort;
	private String  url;

	private Map<String, Object> extra;

	public MenuTree() {
	}

	public MenuTree(String id, String name, String parentId) {
		this.id = id;
		this.parentId = parentId;
		this.name = name;
		this.label = name;
	}

	public MenuTree(String id, String name, MenuTree parent) {
		this.id = id;
		this.parentId = parent.getId();
		this.name = name;
		this.label = name;
	}

	public MenuTree(SysMenu menuVo) {
		this.id = String.valueOf(menuVo.getMenuId());
		this.parentId = String.valueOf(menuVo.getParentId());
		this.icon = menuVo.getIcon();
		this.name = menuVo.getName();
		this.path = menuVo.getPath();
		this.type = menuVo.getType();
		this.label = menuVo.getName();
		this.sort = menuVo.getSortOrder();
		this.keepAlive = menuVo.getKeepAlive();
		this.url = "";
		this.authority = menuVo.getPermission();
	}
}
