/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.vo;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysPost;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysRole;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lengleng
 * @date 2019/2/1
 */
@Data
public class UserVO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
	private String userId;

	/**
	 * 用户名
	 */
	private String username;

	/**
	 * 用户名
	 */
	private String nickname;

	/**
	 * 密码
	 */
	private String password;

	/**
	 * 随机盐
	 */
	private String salt;

	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;

	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;

	/**
	 * 0-正常，1-删除
	 */
	private String delFlag;

	/**
	 * 锁定标记
	 */
	private String lockFlag;

	/**
	 * 简介
	 */
	private String phone;

	/**
	 * 头像
	 */
	private String avatar;

	/**
	 * 部门ID
	 */
	private Long deptId;

	/**
	 * 部门名称
	 */
	private String deptName;

	/**
	 * 角色列表
	 */
	private List<SysRole> roleList;

	/**
	 * 岗位列表
	 */
	private List<SysPost> postList;

	/**
	 * 用户分组
	 */
	private String userGroup;

	/**
	 * 职务
	 */
	private String post;

	/**
	 * 邮箱
	 */
	private String email;

	/**
	 * 是否是系统内置
	 */
	private String systemFlag;

	/**
	 *  LDAP_DN
	 */
	@Schema(description = "LDAP_DN")
	private String ldapDn;

	/**
	 * @Author fxj
	 * @Description  0 系统用户 1 LDAP用户 2 B端用户 3.微信用户  默认系统用户
	 * @Date 14:56 2023/1/6
	 **/
	private String type;
}
