/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpCategorizeFormInfo;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpFormInfo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysOutEmpCategorizeFormInfoVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysOutEmpFormInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutEmpFormInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 瓜子采集字段配置表（前端用配置进行展示）
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysoutempforminfo" )
@Tag(name = "瓜子采集字段配置表（前端用配置进行展示）管理")
public class SysOutEmpFormInfoController {

    private final  SysOutEmpFormInfoService sysOutEmpFormInfoService;


	/**
	 * 瓜子采集配置列表
	 * @param isLookToc C端：0
	 * @return List<SysOutEmpCategorizeFormInfoVo>
	 */
	@Operation(description = "瓜子采集配置列表")
	@GetMapping("/configList")
	public R<List<SysOutEmpCategorizeFormInfoVo>> getConfigList(@RequestParam String isLookToc) {
		return  new R<>(sysOutEmpFormInfoService.getConfigList(isLookToc));
	}

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param sysOutEmpFormInfo 瓜子采集字段配置表（前端用配置进行展示）
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<SysOutEmpFormInfoVo>> getSysOutEmpFormInfoPage(Page<SysOutEmpFormInfo> page, SysOutEmpFormInfoVo sysOutEmpFormInfo) {
        return  new R<>(sysOutEmpFormInfoService.getSysOutEmpFormInfoPage(page,sysOutEmpFormInfo));
    }
    /**
     * 不分页查询
     * @param sysOutEmpFormInfo 瓜子采集字段配置表（前端用配置进行展示）
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<SysOutEmpFormInfoVo>> getSysOutEmpFormInfoNoPage(@RequestBody SysOutEmpFormInfoVo sysOutEmpFormInfo) {
        return R.ok(sysOutEmpFormInfoService.noPageDiy(sysOutEmpFormInfo));
    }

    /**
     * 通过id查询瓜子采集字段配置表（前端用配置进行展示）
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('admin_sysoutempforminfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutempforminfo_get')" )
    public R<SysOutEmpFormInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(sysOutEmpFormInfoService.getById(id));
    }

    /**
     * 新增瓜子采集字段配置表（前端用配置进行展示）
     * @param sysOutEmpFormInfo 瓜子采集字段配置表（前端用配置进行展示）
     * @return R
     */
    @Operation(summary = "新增瓜子采集字段配置表（前端用配置进行展示）", description = "新增瓜子采集字段配置表（前端用配置进行展示）：hasPermission('admin_sysoutempforminfo_add')")
    @SysLog("新增瓜子采集字段配置表（前端用配置进行展示）" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutempforminfo_add')" )
    public R<Boolean> save(@RequestBody SysOutEmpFormInfo sysOutEmpFormInfo) {
        return R.ok(sysOutEmpFormInfoService.save(sysOutEmpFormInfo));
    }

    /**
     * 修改瓜子采集字段配置表（前端用配置进行展示）
     * @param sysOutEmpFormInfo 瓜子采集字段配置表（前端用配置进行展示）
     * @return R
     */
    @Operation(summary = "修改瓜子采集字段配置表（前端用配置进行展示）", description = "修改瓜子采集字段配置表（前端用配置进行展示）：hasPermission('admin_sysoutempforminfo_edit')")
    @SysLog("修改瓜子采集字段配置表（前端用配置进行展示）" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutempforminfo_edit')" )
    public R<Boolean> updateById(@RequestBody SysOutEmpFormInfo sysOutEmpFormInfo) {
        return R.ok(sysOutEmpFormInfoService.updateById(sysOutEmpFormInfo));
    }

    /**
     * 通过id删除瓜子采集字段配置表（前端用配置进行展示）
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除瓜子采集字段配置表（前端用配置进行展示）", description = "通过id删除瓜子采集字段配置表（前端用配置进行展示）：hasPermission('admin_sysoutempforminfo_del')")
    @SysLog("通过id删除瓜子采集字段配置表（前端用配置进行展示）" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutempforminfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(sysOutEmpFormInfoService.removeById(id));
    }

}
