/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.admin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpCategorizeFormInfo;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpFormInfo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysOutEmpCategorizeFormInfoVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysOutEmpFormInfoVo;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysOutEmpFormInfoMapper;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutEmpCategorizeFormInfoService;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutEmpFormInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.*;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;


/**
 * 瓜子采集字段配置表（前端用配置进行展示）
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class SysOutEmpFormInfoServiceImpl extends ServiceImpl<SysOutEmpFormInfoMapper, SysOutEmpFormInfo> implements SysOutEmpFormInfoService {

	private final SysOutEmpCategorizeFormInfoService categorizeFormInfoService;

	/**
	 * 瓜子C端采集配置列表
	 *
	 * @return List<SysOutEmpCategorizeFormInfoVo>
	 */
	@Override
	public List<SysOutEmpCategorizeFormInfoVo> getConfigList(String isLookToc) {

		List<SysOutEmpCategorizeFormInfoVo> categorizeFormInfoVoList = categorizeFormInfoService.getCategorizeVoList(isLookToc);
		if(Common.isEmpty(categorizeFormInfoVoList)){
			return categorizeFormInfoVoList;
		}

		Map<String,List<SysOutEmpFormInfo>> formListMap = new HashMap<>();

		LambdaQueryWrapper<SysOutEmpFormInfo> formQuery = Wrappers.<SysOutEmpFormInfo>lambdaQuery()
				.eq(SysOutEmpFormInfo::getDelFlag, CommonConstants.ZERO_STRING)
				.orderByAsc(SysOutEmpFormInfo::getSort).orderByDesc(SysOutEmpFormInfo::getId);
		List<SysOutEmpFormInfo> formInfoList = this.list(formQuery);
		if(Common.isEmpty(formInfoList)){
			return categorizeFormInfoVoList;
		}

		for(SysOutEmpFormInfo formInfo : formInfoList){
			// 获取指定分类下的配置字段
			List<SysOutEmpFormInfo> formInfoListByCategorize = formListMap.get(formInfo.getCategorizeId());
			if(Common.isEmpty(formInfoListByCategorize)) {
				// 关联的模块列表
				formInfoListByCategorize = new ArrayList<>();
			}
			formInfoListByCategorize.add(formInfo);
			formListMap.put(formInfo.getCategorizeId(), formInfoListByCategorize);
		}

		for(SysOutEmpCategorizeFormInfoVo categorizeFormInfoVo : categorizeFormInfoVoList){
			if(Common.isNotNull(formListMap.get(categorizeFormInfoVo.getId()))){
				categorizeFormInfoVo.setSysOutEmpFormInfoList(formListMap.get(categorizeFormInfoVo.getId()));
			}
		}

		return categorizeFormInfoVoList;
	}

	/**
	 * 瓜子采集字段配置表（前端用配置进行展示）简单分页查询
	 *
	 * @param sysOutEmpFormInfo 瓜子采集字段配置表（前端用配置进行展示）
	 * @return
	 */
	@Override
	public IPage<SysOutEmpFormInfoVo> getSysOutEmpFormInfoPage(Page<SysOutEmpFormInfo> page, SysOutEmpFormInfoVo sysOutEmpFormInfo) {
		return baseMapper.getSysOutEmpFormInfoPage(page, sysOutEmpFormInfo);
	}

	@Override
	public List<SysOutEmpFormInfoVo> noPageDiy(SysOutEmpFormInfoVo searchVo) {
		LambdaQueryWrapper<SysOutEmpFormInfo> wrapper = buildQueryWrapper(searchVo);

		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return null;
	}


	private LambdaQueryWrapper buildQueryWrapper(SysOutEmpFormInfoVo entity) {
		LambdaQueryWrapper<SysOutEmpFormInfo> wrapper = Wrappers.lambdaQuery();

		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(SysOutEmpFormInfo::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
