package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * @Author fxj
 * @Description 附件信息表
 * @Date 11:07 2022/6/22
**/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_atta_info")
@Tag(name = "附件信息表")
public class TAttaInfo  extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键")
    private String id;
    /**
     * 资源名称
     */
    @NotBlank(message = "资源名称不能为空")
    @Length(max = 50, message = "资源名称不能超过50个字符")
    @Schema(description = "资源名称")
    private String attaName;
    /**
     * 资源地址
     */
    @NotBlank(message = "资源地址不能为空")
    @Length(max = 100, message = "资源地址不能超过100个字符")
    @Schema(description = "资源地址")
    private String attaSrc;
    /**
     * 资源大小
     */
    @Schema(description = "资源大小")
    private Long attaSize;
    /**
     * 资源类型
     */
    @Length(max = 10, message = "资源类型不能超过10个字符")
    @Schema(description = "资源类型")
    private String attaType;
    /**
     * 关系类型(0客户附件1联系人附件2跟进记录附件3合同附件4合同归档附件5报价单)
     */
    @NotBlank(message = "关系类型(0员工附件-学历 1 员工附件-伤残 2.员工附件-职业)不能为空")
    @Length(max = 2, message = "关系类型(0员工附件-学历 1 员工附件-伤残 2.员工附件-职业)不能超过2个字符")
    @Schema(description = "关系类型(0员工附件-学历 1 员工附件-伤残 2.员工附件-职业)")
    private String relationType;
    /**
     * 实体id和关系类型共同确定附件所属
     */
    @NotBlank(message = "实体id和关系类型共同确定附件所属不能为空")
    @Length(max = 32, message = "实体id和关系类型共同确定附件所属不能超过32个字符")
    @Schema(description = "实体id和关系类型共同确定附件所属")
    private String domainId;

	/**
	 * 地址URL
	 */
	@Length(max = 100, message = "地址URL不能超过100个字符")
	@Schema(description = "地址URL")
	@TableField(exist = false)
	private String attaUrl;
}
