package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @Author fxj
 * @Date 2022/7/19
 * @Description
 * @Version 1.0
 */
@Data
public class EmpAddDispatchVo extends TEmployeeInfo {


	/**
	 * 员工类型（字典值，0外包1派遣2代理3内部员工）
	 */
	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型（字典值，0外包1派遣2代理3内部员工）")
	private String empNatrue;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	@NotNull(message = "员工姓名不可为空")
	@Size(max = 20, message = "员工姓名不可超过20位")
	private String empName;

	/**
	 * 身份证号码
	 */
	@Schema(description = "身份证号码")
	@NotNull(message = "身份证号码不可为空")
	@Size(max = 20, message = "身份证号码不可超过20位")
	private String empIdcard;

	/**
	 * 民族
	 */
	@Schema(description = "民族")
	private String empNational;

	/**
	 * 手机号码
	 */
	@Schema(description = "手机号码")
	@NotNull(message = "手机号码不可为空")
	@Size(max = 11, min = 11, message = "手机号码只能11位")
	private String empPhone;

	/**
	 * 身份证-省
	 */
	@Schema(description = "身份证-省")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idProvince;

	/**
	 * 身份证-市
	 */
	@Schema(description = "身份证-市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idCity;

	/**
	 * 身份证-县
	 */
	@Schema(description = "身份证-县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idTown;

	/**
	 * 户口性质
	 */
	@Schema(description = "户口性质")
	private String empRegisType;

	/**
	 * 档案-省
	 */
	@Schema(description = "档案-省")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileProvince;

	/**
	 * 档案-市
	 */
	@Schema(description = "档案-市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileCity;

	/**
	 * 档案-县
	 */
	@Schema(description = "档案-县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileTown;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 人员档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）
	 * 1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入
	 */
	@Schema(description = "人员档案来源（字典：1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入）")
	private String fileSource;

	/**
	 * 人员档案状态（0草稿、1已审核）
	 */
	@Schema(description = "人员档案状态（0草稿、1已审核）")
	private Integer status;

	/**
	 * 档案状态（0正常；1已减档）
	 */
	@Schema(description = "档案状态（0正常；1已减档）")
	private Integer fileStatus;

	/**
	 * 现存项目数
	 */
	@Schema(description = "现存项目数")
	private Integer projectNum;

	/**
	 * 员工合同状态（字典）
	 */
	@Schema(description = "员工合同状态（字典）0初始状态")
	private Integer contractStatus;

	/**
	 * 社保状态（字典）
	 */
	@Schema(description = "社保状态（字典）0初始状态")
	private Integer socialStatus;

	/**
	 * 公积金状态（字典）0初始状态
	 */
	@Schema(description = "公积金状态（字典）0初始状态")
	private Integer fundStatus;

	/**
	 * 是否删除 0否/1是
	 */
	@Schema(description = "是否删除 0否/1是")
	private String deleteFlag;

}
