package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2022/7/19
 * @Description 派单新增项目档案
 * @Version 1.0
 */
@Data
public class EmpProjectDispatchVo implements Serializable {

	/**
	 * 项目档案ID
	 */
	@Schema(description ="项目档案ID")
	private String id;
	/**
	 * 人员档案主表id
	 */
	@Schema(description ="人员档案主表id")
	@Size(max = 32, message = "人员档案主表id不可超过32位")
	private String empId;
	/**
	 * 员工主码
	 */
	@Schema(description ="员工主码")
	@Size(max = 20, message = "员工主码不可超过20位")
	private String empCode;
	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@NotNull(message = "员工类型不能为空")
	@ExcelAttribute(name = "员工类型",isNotEmpty = true, errorInfo = "员工类型不能为空",maxLength = 5,isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工类型")
	private String empNatrue;

	/**
	 * 员工姓名
	 */
	@NotNull(message = "员工姓名不能为空")
	@ExcelAttribute(name = "员工姓名",isNotEmpty = true, errorInfo = "员工姓名不能为空",maxLength = 20)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工姓名")
	private String empName;

	/**
	 * 身份证号码
	 */
	@NotNull(message = "身份证号不能为空")
	@ExcelAttribute(name = "身份证号",isNotEmpty = true, errorInfo = "身份证号不能为空",maxLength = 20)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="身份证号")
	private String empIdcard;
	/**
	 * 项目编码
	 */
	@NotNull(message = "项目编码不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目编码")
	@ExcelAttribute(name = "项目编码",isNotEmpty = true, errorInfo = "项目编码不能为空",maxLength = 20)
	private String deptId;
	/**
	 * 项目编码
	 */
	@NotNull(message = "项目编码不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目编码")
	@ExcelAttribute(name = "项目编码",isNotEmpty = true, errorInfo = "项目编码不能为空",maxLength = 20)
	private String deptNo;

	/**
	 * 项目名称
	 */
	@Schema(description ="项目名称")
	private String deptName;

	/**
	 * 合同类型（字典值）
	 */
	@NotNull(message = "合同类型不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="合同类型")
	@ExcelAttribute(name = "合同类型",isNotEmpty = true, errorInfo = "合同类型不能为空",maxLength = 10,isDataId = true,dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	private String contractType;

	/**
	 * 工时制
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="工时制")
	@ExcelAttribute(name = "工时制",maxLength = 10,isDataId = true,dataType = ExcelAttributeConstants.WORKING_HOURS)
	private String workingHours;

	/**
	 * 就职岗位
	 */
	@NotNull(message = "就职岗位不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="就职岗位")
	@ExcelAttribute(name = "就职岗位",isNotEmpty = true, errorInfo = "就职岗位不能为空",maxLength = 20)
	private String post;

	/**
	 * 员工项目编码
	 */
	@Schema(description ="员工项目编码")
	@Size(max = 20, message = "员工项目编码不可超过20位")
	private String empNo;

	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人-姓名")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;

	/**
	 * 创建者
	 */
	@Schema(description = "创建人")
	@TableField(fill = FieldFill.INSERT)
	@ExcelIgnore
	private String createBy;

	/**
	 * 业务类型一级分类
	 */
	@Schema(description ="业务类型一级分类")
	private String businessPrimaryType;

	/**
	 * 业务类型二级分类
	 */
	@Schema(description ="业务类型二级分类")
	private String businessSecondType;

	/**
	 * 业务类型三级分类
	 */
	@Schema(description ="业务类型三级分类")
	private String businessThirdType;
	/**
	 * 客户id
	 */
	@Schema(description ="客户id")
	private String unitId;

	/**
	 * 客户名称
	 */
	@Schema(description ="客户名称")
	private String unitName;

	/**
	 * 客户编码
	 */
	@Schema(description ="客户编码")
	private String unitNo;

	/**
	 * 社保-省
	 */
	@Schema(description = "社保-省")
	private Integer socialProvince;

	/**
	 * 社保-市
	 */
	@Schema(description = "社保-市")
	private Integer socialCity;

	/**
	 * 社保-县
	 */
	@Schema(description = "社保-县")
	private Integer socialTown;

	/**
	 * 试用期（单位月）
	 */
	@Schema(description ="试用期（单位月）")
	private String tryPeriod;
}
