package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 员工伤残excel 对应的实体
 *
 * @author fxz
 * @date 2022/3/21
 */
@Data
@ColumnWidth(30)
public class EmpWorkRecordExcelVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名",isNotEmpty = true,errorInfo = "员工姓名不可为空",maxLength = 20)
	@NotNull(message = "员工姓名不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "身份证号",isNotEmpty = true,errorInfo = "员工身份证不可为空",maxLength = 20)
	@NotNull(message = "员工身份证不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="身份证号")
	private String empIdcard;

	/**
	 * 工作单位
	 */
	@ExcelAttribute(name = "工作单位",isNotEmpty = true,errorInfo = "工作单位不可为空",maxLength = 100)
	@NotNull(message = "工作单位不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="工作单位")
	private String workUnit;

	/**
	 * 工作部门
	 */
	@ExcelAttribute(name = "工作部门",isNotEmpty = true,errorInfo = "工作部门不可为空",maxLength = 100)
	@NotNull(message = "工作部门不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="工作部门")
	private String workDepart;

	/**
	 * 工作岗位
	 */
	@ExcelAttribute(name = "工作岗位",maxLength = 100)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="工作岗位")
	private String workJob;

	/**
	 * 工作类型
	 */
	@ExcelAttribute(name = "工作类型",isDataId = true,dataType = ExcelAttributeConstants.WORKINFO_TYPE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="工作类型")
	private String workingType;

	/**
	 * 是否在岗：0是/1否
	 */
	@ExcelAttribute(name = "在职状态",isNotEmpty = true,errorInfo = "在职状态不可为空",isDataId = true,readConverterExp = "0=在职,1=离职")
	@NotNull(message = "是否在岗不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="在职状态")
	private String workingStatus;

	/**
	 * 开始工作日期
	 */
	@ExcelAttribute(name = "开始工作日期",isNotEmpty = true,errorInfo = "开始工作日期不可为空",isDate = true)
	@DateTimeFormat("yyyy-MM-dd")
	@NotNull(message = "开始工作日期不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="开始工作日期")
	private Date startDate;

	/**
	 * 结束工作日期
	 */
	@ExcelAttribute(name = "结束工作日期",isDate = true)
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="结束工作日期")
	private Date endDate;


	/*JSR303 是一套JavaBean参数校验的标准，它定义了很多常用的校验注解，我们可以直接将这些注解加在我们JavaBean的属性上面，就可以在需要校验的时候进行校验了。注解如下：
	参考配置
	@Null 限制只能为null
	@NotNull 限制必须不为null
	@AssertFalse 限制必须为false
	@AssertTrue 限制必须为true
	@DecimalMax(value) 限制必须为一个不大于指定值的数字
	@DecimalMin(value) 限制必须为一个不小于指定值的数字
	@Digits(integer,fraction) 限制必须为一个小数，且整数部分的位数不能超过integer，小数部分的位数不能超过fraction
	@Future 限制必须是一个将来的日期
	@Max(value) 限制必须为一个不大于指定值的数字
	@Min(value) 限制必须为一个不小于指定值的数字
	@Past 限制必须是一个过去的日期
	@Pattern(value) 限制必须符合指定的正则表达式
	@Size(max,min) 限制字符长度必须在min到max之间
	@Past 验证注解的元素值（日期类型）比当前时间早
	@NotEmpty 验证注解的元素值不为null且不为空（字符串长度不为0、集合大小不为0）
	@NotBlank 验证注解的元素值不为空（不为null、去除首位空格后长度为0），不同于@NotEmpty，@NotBlank只应用于字符串且在比较时会去除字符串的空格
	@Email 验证注解的元素值是Email，也可以通过正则表达式和flag指定自定义的email格式*/

}
