/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 人员档案表excel导出对应的实体
 *
 * @author hgw
 * @date 2022-6-24 15:15:24
 */
@Data
@ColumnWidth(10)
public class EmployeeExportVO extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "id")
	private String id;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工主码")
	private String empCode;

	@ExcelAttribute(name = "员工类型", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工类型")
	private String empNatrue;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	private String empName;

	@ColumnWidth(20)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证号")
	private String empIdcard;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证开始日期")
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDateTime validityStart;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证截止日期")
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDateTime validityEnd;

	@ExcelAttribute(name = "婚姻状况", isDataId = true,dataType = ExcelAttributeConstants.EMP_MARRIED)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "婚姻状况")
	private String empMarriStatus;

	@ExcelAttribute(name = "民族", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATIONAL)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "民族")
	private String empNational;

	@ExcelAttribute(name = "政治面貌", isDataId = true,dataType = ExcelAttributeConstants.EMP_POLITICAL)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "政治面貌")
	private String politicalStatus;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "手机号码")
	private String empPhone;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "邮箱")
	private String empEmail;

	@ExcelAttribute(name = "户籍所在省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在省")
	private String idProvince;

	@ExcelAttribute(name = "户籍所在市",  isArea = true, parentField = "idProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在市")
	private String idCity;

	@ExcelAttribute(name = "户籍所在县",  isArea = true, parentField = "idCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在县")
	private String idTown;

	@ExcelAttribute(name = "户口性质", isDataId = true,dataType = ExcelAttributeConstants.EMP_REGISTYPE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户口性质")
	private String empRegisType;

	@ExcelAttribute(name = "档案所在省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在省")
	private String fileProvince;

	@ExcelAttribute(name = "档案所在市", isArea = true, parentField = "fileProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在市")
	private String fileCity;

	@ExcelAttribute(name = "档案所在县", isArea = true, parentField = "fileCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在县")
	private String fileTown;

	@ExcelAttribute(name = "是否大专及以上", readConverterExp = "0=否,1=是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否大专及以上")
	private String isCollege;

	@ExcelAttribute(name = "最高学历", isDataId = true,dataType = ExcelAttributeConstants.EDUCATION)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最高学历")
	private String hignEducation;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "学校")
	private String school;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "专业")
	private String major;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "入学时间")
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDateTime admissionDate;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "毕业时间")
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDateTime gradutionDate;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案备注")
	private String remark;

	/**
	 * 人员档案来源（字典：4档案新增、5项目档案新建、1社保/公积金、3商险、2薪酬）
	 * 档案新建、批量导入、社保/公积金派单、商险派单、人员发薪
	 */
	@ExcelAttribute(name = "人员档案来源", readConverterExp = "1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "人员档案来源")
	private String fileSource;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否多项目")
	private String isProjects;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "现存项目数")
	private Integer projectNum;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目名称")
	private String deptName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目编码")
	private String deptNo;

	/**
	 * 员工合同状态（字典）
	 */
	@ExcelAttribute(name = "合同状态", isDataId = true,dataType = ExcelAttributeConstants.PERSONNEL_STATE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "合同状态")
	private String contractStatus;

	/**
	 * 商险状态（字典）
	 */
	@ExcelAttribute(name = "商险状态", isDataId = true,dataType = ExcelAttributeConstants.COMMERCIAL_SATTE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险状态")
	private String insuranceStatus;

	/**
	 * 社保状态（字典）
	 */
	@ExcelAttribute(name = "社保状态", isDataId = true,dataType = ExcelAttributeConstants.SOCIAL_ECURITY_STATE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保状态")
	private String socialStatus;

	/**
	 * 公积金状态（字典）
	 */
	@ExcelAttribute(name = "公积金状态", isDataId = true,dataType = ExcelAttributeConstants.FUND_STATUS)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金状态")
	private String fundStatus;

	/**
	 * 近3个月发薪（0否；1是）
	 */
	@ExcelAttribute(name = "近3个月发薪", readConverterExp = "0=无,1=是,2=否")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "近3个月发薪")
	private String salaryStatus;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减档人")
	private String leaveUserName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减档时间")
	private LocalDateTime leaveTime;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减档原因")
	@ExcelAttribute(name = "减档原因", isDataId = true,dataType = ExcelAttributeConstants.DOWNSHIFT_REASON)
	private String leaveReason;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减档备注")
	private String leaveRemark;

	/**
	 * 通信地址
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "通信地址")
	private String contactAddress;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位名称")
	private String unitName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位编码")
	private String unitNo;

	@ExcelAttribute(name = "人员档案状态", readConverterExp = "0=草稿,1=已审核")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "人员档案状态")
	private String status;

}
