package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCutsomerDataPermisson;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCutsomerDataPermissonService;
import com.yifu.cloud.plus.v1.yifu.archives.service.TSettleDomainService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * 客户数据权限表
 *
 * @author fxj
 * @date 2022-07-13 15:20
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tcutsomerdatapermisson")
@Tag(name = "客户数据权限表")
public class TCutsomerDataPermissonController {

  private final TCutsomerDataPermissonService tCutsomerDataPermissonService;
  private final TSettleDomainService settleDomainService;

  /**
   * 简单分页查询
   * @param page 分页对象
   * @param tCutsomerDataPermisson 客户数据权限表
   * @return
   */
  @Operation(description = "简单分页查询")
  @GetMapping("/page")
  public R<IPage<TCutsomerDataPermisson>> getTCutsomerDataPermissonPage(Page<TCutsomerDataPermisson> page, TCutsomerDataPermisson tCutsomerDataPermisson) {
    return  new R<>(tCutsomerDataPermissonService.getTCutsomerDataPermissonPage(page,tCutsomerDataPermisson));
  }

  /**
   * 导出list
   * @param tCutsomerDataPermisson 客户数据权限表
   * @return
   */
  @Operation(description = "导出的list")
  @GetMapping("/getList")
  public R<List<TCutsomerDataPermisson>> getTCutsomerDataPermissonList(TCutsomerDataPermisson tCutsomerDataPermisson) {
    return  new R<>(tCutsomerDataPermissonService.getTCutsomerDataPermissonList(tCutsomerDataPermisson));
  }

  /**
   * @Author fxj
   * @Description  获取实体的权限: type-类型0:客户1:合同2:项目(不传默认2项目)
   * @Date 15:20 2022/7/13
   * @Param
   * @return
  **/
  @Operation(description = "获取实体的权限:默认项目")
  @GetMapping("/getPermissonByTypeAndId")
  public R<IPage<TCutsomerDataPermisson>> getTCutsomerDataPermissonByTypeAndId(@RequestParam String settleDomainId) {
    TCutsomerDataPermisson tp = new TCutsomerDataPermisson();
	tp.setSettleDomainId(settleDomainId);
    return  new R(tCutsomerDataPermissonService.list(Wrappers.lambdaQuery(tp)));
  }

	/**
	 * @Author fxj
	 * @Description 获取实体的权限: type-类型0:客户1:合同2:项目(不传默认2项目)
	 * @Date 15:21 2022/7/13
	 * @Param
	 * @return
	**/
  @Operation(description = "权限复制 权限同项目分配客服（wxhr:tsettledomain_assign_customerservice）")
  @GetMapping("/copy")
  public R<String> insertForCopyCutsomerDataPermisson(String[] srcUser, String[] beUser) {
     YifuUser user = SecurityUtils.getUser();
      R<String> result = tCutsomerDataPermissonService.insertForCopyCutsomerDataPermisson(srcUser, beUser, user);
      if(CommonConstants.SUCCESS.equals(result.getCode())){//权限刷新
          settleDomainService.removeSettleCache(user, Arrays.asList(beUser));
      }
      return result ;
  }

  /**
   * 通过id查询单条记录
   * @param id
   * @return R
   */
  @Operation(description = "id查询")
  @GetMapping("/{id}")
  public R<TCutsomerDataPermisson> getById(@PathVariable("id") String id){
    return new R<>(tCutsomerDataPermissonService.getById(id));
  }

  /**
   * 新增记录
   * @param tCutsomerDataPermisson
   * @return R
   */
  @Operation(description = "新增")
  @SysLog("新增客户数据权限表")
  @PostMapping
  public R<String> save(@RequestBody TCutsomerDataPermisson tCutsomerDataPermisson){
	YifuUser user = SecurityUtils.getUser();
	settleDomainService.removeSettleCache(user, Arrays.asList(tCutsomerDataPermisson.getUserId()));
	if (Common.isNotNull(tCutsomerDataPermisson.getUserId()) && Common.isNotNull(tCutsomerDataPermisson.getSettleDomainId())) {
		List<TCutsomerDataPermisson> list = tCutsomerDataPermissonService.list(Wrappers.<TCutsomerDataPermisson>query().lambda()
				.eq(TCutsomerDataPermisson::getUserId, tCutsomerDataPermisson.getUserId())
				.eq(TCutsomerDataPermisson::getSettleDomainId, tCutsomerDataPermisson.getSettleDomainId())
		);
		if (list != null && !list.isEmpty()) {
			return R.failed("该用户已存在该项目");
		}
		tCutsomerDataPermissonService.save(tCutsomerDataPermisson);
		return R.ok();
	} else {
		return R.failed("用户id与项目id必填");
	}
  }

  /**
   * 修改记录
   * @param tCutsomerDataPermisson
   * @return R
   */
  @Operation(description = "修改")
  @SysLog("修改客户数据权限表")
  @PutMapping
  public R<Boolean> update(@RequestBody TCutsomerDataPermisson tCutsomerDataPermisson) {
  	YifuUser user = SecurityUtils.getUser();
  	settleDomainService.removeSettleCache(user, Arrays.asList(tCutsomerDataPermisson.getUserId()));
    return new R<>(tCutsomerDataPermissonService.updateById(tCutsomerDataPermisson));
  }

  /**
   * 通过id删除一条记录
   * @param id
   * @return R
   */
  @Operation(description = "删除(tcutsomerdatapermisson_del)")
  @SysLog("删除客户数据权限表")
  @DeleteMapping("/{id}")
  public R<Boolean> removeById(@PathVariable String id){
      YifuUser user = SecurityUtils.getUser();
      TCutsomerDataPermisson tdp = tCutsomerDataPermissonService.getById(id);
      if(null == tdp){
          return new R<>(true);
      }
      //刷新缓存
      settleDomainService.removeSettleCache(user, Arrays.asList(tdp.getUserId()));
      return new R<>(tCutsomerDataPermissonService.removeById(id));
  }

}
