/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpProfessionalQualification;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmpProfessionalQualificationService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.CertifySearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.log4j.Log4j2;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;


/**
 * 员工职业资格信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Log4j2
@RestController
@RequiredArgsConstructor
@RequestMapping("/tempprofessionalqualification" )
@Tag(name = "员工职业资格信息表管理")
public class TEmpProfessionalQualificationController {

    private final TEmpProfessionalQualificationService qualificationService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param searchVo 员工职业资格信息表
     * @return
     */
    @Operation(description = "分页查询")
    @GetMapping("/page" )
    public R<IPage<TEmpProfessionalQualification>> getTEmpProfessionalQualificationPage(Page page, CertifySearchVo searchVo) {
        return R.ok(qualificationService.pageDiy(page, searchVo));
    }
	/**
	 * 不分页查询
	 * @param searchVo 员工职业资格信息表
	 * @return
	 */
	@Operation(description = "不分页查询")
	@PostMapping("/noPage" )
	public R<List<TEmpProfessionalQualification>> getTEmpProfessionalQualificationNoPage(@RequestBody CertifySearchVo searchVo) {
		return R.ok(qualificationService.getDataNoPage(searchVo));
	}

    /**
     * 通过id查询员工职业资格信息表
     * @param id id
     * @return R
     */
    @Operation(description = "通过id查询hasPermission('archives_tempprofessionalqualification_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_tempprofessionalqualification_get')" )
    public R getById(@PathVariable("id" ) String id) {
        return R.ok(qualificationService.getById(id));
    }

    /**
     * 新增员工职业资格信息表
     * @param tEmpProfessionalQualification 员工职业资格信息表
     * @return R
     */
    @Operation(description = "新增员工职业资格信息表hasPermission('archives_tempprofessionalqualification_add')")
    @SysLog("新增员工职业资格信息表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('archives_tempprofessionalqualification_add')" )
    public R<Boolean> save(@RequestBody TEmpProfessionalQualification tEmpProfessionalQualification) {
        return qualificationService.saveDiy(tEmpProfessionalQualification);
    }

    /**
     * 修改员工职业资格信息表
     * @param tEmpProfessionalQualification 员工职业资格信息表
     * @return R
     */
    @Operation(description = "修改员工职业资格信息表hasPermission('archives_tempprofessionalqualification_edit')")
    @SysLog("修改员工职业资格信息表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('archives_tempprofessionalqualification_edit')" )
    public R updateById(@RequestBody TEmpProfessionalQualification tEmpProfessionalQualification) {
        return qualificationService.updateByIdDiy(tEmpProfessionalQualification);
    }

    /**
     * 通过id删除员工职业资格信息表
     * @param id id
     * @return R
     */
    @Operation(description = "通过id删除员工职业资格信息表hasPermission('archives_tempprofessionalqualification_del')")
    @SysLog("通过id删除员工职业资格信息表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_tempprofessionalqualification_del')" )
    public R removeById(@PathVariable String id) {
        return R.ok(qualificationService.removeById(id));
    }

	/**
	 * 通过ids删除员工职业资格信息表
	 * @param ids id
	 * @return R
	 */
	@Operation(description = "通过ids删除员工职业资格信息表hasPermission('archives_tempprofessionalqualification_del_batch')")
	@SysLog("通过ids删除员工职业资格信息表" )
	@DeleteMapping("/removeByIds" )
	@PreAuthorize("@pms.hasPermission('archives_tempprofessionalqualification_del_batch')" )
	public R removeByIds(@RequestBody(required = true) String[] ids) {
		List<String> idList = Arrays.asList(ids);
		return R.ok(qualificationService.removeByIds(idList));
	}
	/**
	 * 批量新增员工证书信息
	 *
	 * @param file
	 * @return
	 * @Author fxj
	 * @Date 2019-08-16
	 **/
	@SneakyThrows
	@Operation(description = "批量新增员工证书信息 hasPermission('archives-professionalqualification-batch-import')")
	@SysLog("批量新增员工证书信息")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('archives-professionalqualification-batch-import')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return qualificationService.importEmpCertificateDiy(file.getInputStream());
	}
}
