/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpBadRecord;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpBadRecordSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 员工不良记录
 *
 * @author fxj
 * @date 2022-06-29 15:50:45
 */
public interface TEmpBadRecordService extends IService<TEmpBadRecord> {

	R<List<ErrorMessage>> importEmpBadRecordDiy(InputStream inputStream);

	R<Boolean> saveDiy(TEmpBadRecord tEmpBadRecord);

	void listExport(HttpServletResponse response, EmpBadRecordSearchVo searchVo);

	IPage<TEmpBadRecord> pageDiy(Page page, EmpBadRecordSearchVo tEmpBadRecord);

	List<TEmpBadRecord> noPageDiy(EmpBadRecordSearchVo tEmpBadRecord);
}
