/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.IdNameNoVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SetInfoVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

import java.util.List;

/**
 * 项目表
 *
 * @author hgw
 * @date 2022-06-20 10:02:28
 */
public interface TSettleDomainService extends IService<TSettleDomain> {

	IPage<TSettleDomain> getPage(Page<TSettleDomain> page, TSettleDomain tSettleDomain);

	/**
	 * @param page
	 * @param idNameNoVo
	 * @Description: 获取客户单位单位
	 * @Author: hgw
	 * @Date: 2022/10/21 10:01
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.archives.vo.IdNameNoVo>
	 **/
	IPage<IdNameNoVo> getUnitPage(Page<IdNameNoVo> page, IdNameNoVo idNameNoVo);

	/**
	 * 清除userId的项目权限缓存
	 *
	 * @param user
	 * @return
	 * @Author fxj
	 * @Date 2022-07-11 16:57
	 **/
	void removeSettleCache(YifuUser user, List<String> userId);

	List<String> getSettleDomainIdsByUserId(String id);

	SetInfoVo getSetInfoByCodes(List<String> codes);

	/**
	 * 通过id获取项目及单位部分信息
	 * @param
	 * @return
	 * @Author fxj
	 * @Date 2019-12-24
	 **/
	TSettleDomainSelectVo selectSettleDomainSelectVosById(TSettleDomainSelectVo settleDomainSelectVo);


	TSettleDomainSelectVo getSettleDomainVoById(String id);

	/**
	 * 获取所有客户单位的项目信息
	 * @param
	 * @return
	 * @Author fxj
	 * @Date 2019-12-24
	 **/
	List<TSettleDomainSelectVo> selectAllSettleDomainSelectVos();

	R updateProjectInfo(List<TSettleDomain> list);

}
