/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCertRecord;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TCertRecordMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TEmployeeContractInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TEmployeeInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TEmployeeProjectMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCertRecordService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.CertRecordSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TCertRecordVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 证明开具记录表
 *
 * @author fxj
 * @date 2022-06-25 11:05:11
 */
@RequiredArgsConstructor
@Service
public class TCertRecordServiceImpl extends ServiceImpl<TCertRecordMapper, TCertRecord> implements TCertRecordService {

	private final TEmployeeProjectMapper projectMapper;

	private final TEmployeeInfoMapper employeeInfoMapper;

	private final TEmployeeContractInfoMapper contractInfoMapper;

	@Override
	public R<TCertRecordVo> getCertRecordInfo(String id) {
		TEmployeeProject project = projectMapper.selectById(id);
		if (!Common.isNotNull(project)){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		TEmployeeInfo employeeInfo = employeeInfoMapper.selectById(project.getEmpId());
		if (!Common.isNotNull(employeeInfo)){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		// 取值最新审核的合同  2022-10-13  倩倩确认 最早取值审核通过的 最早合同开始时间
		TEmployeeContractInfo first = contractInfoMapper.selectOne(Wrappers.<TEmployeeContractInfo>query().lambda()
				.eq(TEmployeeContractInfo::getDeleteFlag,CommonConstants.ZERO_STRING)
				.eq(TEmployeeContractInfo::getAuditStatus,CommonConstants.TWO_STRING)
				.ne(TEmployeeContractInfo::getSituation,"终止")
				.ne(TEmployeeContractInfo::getSituation,"作废")
				.eq(TEmployeeContractInfo::getEmpIdcard,employeeInfo.getEmpIdcard())
				.orderByAsc(TEmployeeContractInfo::getContractStart)
				.last(CommonConstants.LAST_ONE_SQL));

		// 取值最早审核的合同
		TEmployeeContractInfo last = contractInfoMapper.selectOne(Wrappers.<TEmployeeContractInfo>query().lambda()
				.eq(TEmployeeContractInfo::getDeleteFlag,CommonConstants.ZERO_STRING)
				.eq(TEmployeeContractInfo::getAuditStatus,CommonConstants.TWO_STRING)
				.ne(TEmployeeContractInfo::getSituation,"终止")
				.ne(TEmployeeContractInfo::getSituation,"作废")
				.eq(TEmployeeContractInfo::getEmpIdcard,employeeInfo.getEmpIdcard())
				.isNotNull(TEmployeeContractInfo::getContractEnd)
				.orderByDesc(TEmployeeContractInfo::getContractEnd)
				.last(CommonConstants.LAST_ONE_SQL));
		TCertRecordVo vo = new TCertRecordVo();
		vo.setEmpIdcard(project.getEmpIdcard());
		vo.setEmpId(project.getEmpId());
		vo.setEmpName(project.getEmpName());
		vo.setPost(project.getPost());
		vo.setProjectName(project.getDeptName());
		vo.setProjectCode(project.getDeptNo());
		vo.setDeptId(project.getDeptId());
		// 最新合同时间
		if (Common.isNotNull(last)){
			if (Common.isNotNull(last.getContractStart())){
				vo.setContractStart(LocalDateTimeUtils.convertDateToLDT(last.getContractStart()));
			}
			if (Common.isNotNull(last.getContractEnd())){
				vo.setContractEnd(LocalDateTimeUtils.convertDateToLDT(last.getContractEnd()));
			}
		}
		// 派减离职时间和原因
		vo.setLeaveTime(employeeInfo.getLeaveTime());
		vo.setLeaveReason(employeeInfo.getLeaveReason());
		// 第一次合同开始时间和创建时间
		if (Common.isNotNull(first) && Common.isNotNull(first.getContractStart())){
			vo.setEntryTime(LocalDateTimeUtils.convertDateToLDT(first.getContractStart()));
			vo.setFirstContractTime(LocalDateTimeUtils.convertDateToLDT(first.getContractStart()));
		}
		vo.setSex(employeeInfo.getEmpSex());
		vo.setIntroductionUnit(CommonConstants.EMPTY_STRING);
		vo.setSeal("安徽皖信人力资源管理有限公司");

		// TODO  参保时间
		vo.setSocialTime(null);
		return R.ok(vo);
	}

	@Override
	public IPage<TCertRecord> pageDiy(Page page, CertRecordSearchVo searchVo) {
		LambdaQueryWrapper<TCertRecord> wrapper = buildQueryWrapper(searchVo);
		if (Common.isNotNull(searchVo.getAuthSql())) {
			wrapper.last(searchVo.getAuthSql() + " order by CREATE_TIME desc");
		} else {
			wrapper.orderByDesc(BaseEntity::getCreateTime);
		}
		return baseMapper.selectPage(page,wrapper);
	}

	@Override
	public List<TCertRecord> getTCertRecordNoPage(CertRecordSearchVo searchVo) {
		LambdaQueryWrapper<TCertRecord> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)){
			wrapper.in(TCertRecord::getId,idList);
		}
		if (Common.isNotNull(searchVo.getAuthSql())) {
			wrapper.last(searchVo.getAuthSql());
		}
		return baseMapper.selectList(wrapper);
	}
	private LambdaQueryWrapper buildQueryWrapper(CertRecordSearchVo entity){
		LambdaQueryWrapper<TCertRecord> wrapper = Wrappers.lambdaQuery();
		wrapper.ne(TCertRecord::getId,CommonConstants.ZERO_STRING);
		if (ArrayUtil.isNotEmpty(entity.getCreateTimes())) {
			wrapper.ge(TCertRecord::getOpenTime, entity.getCreateTimes()[0])
					.le(TCertRecord::getOpenTime,
							entity.getCreateTimes()[1]);
		}
		if (Common.isNotNull(entity.getEmpName())){
			wrapper.likeRight(TCertRecord::getEmpName,entity.getEmpName());
		}
		if (Common.isNotNull(entity.getEmpIdcard())){
			wrapper.likeRight(TCertRecord::getEmpIdcard,entity.getEmpIdcard());
		}
		if (Common.isNotNull(entity.getProjectName())){
			wrapper.likeRight(TCertRecord::getProjectName,entity.getProjectName());
		}
		if (Common.isNotNull(entity.getType())){
			wrapper.likeRight(TCertRecord::getType,entity.getType());
		}
		if (Common.isNotNull(entity.getCreateName())){
			wrapper.eq(TCertRecord::getCreateName,entity.getCreateName());
		}
		return wrapper;
	}
}
