package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCutsomerDataPermisson;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TCutsomerDataPermissonMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCutsomerDataPermissonService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.*;


/**
 * 客户数据权限表
 *
 * @author pwang
 * @date 2019-07-19 11:42:58
 */

@Service
@RequiredArgsConstructor
@EnableConfigurationProperties(DaprUpmsProperties.class)
@Slf4j
public class TCutsomerDataPermissonServiceImpl extends ServiceImpl<TCutsomerDataPermissonMapper, TCutsomerDataPermisson> implements TCutsomerDataPermissonService {

	/**
	 * 客户数据权限表简单分页查询
	 *
	 * @param tCutsomerDataPermisson 客户数据权限表
	 * @return
	 */
	@Override
	public IPage<TCutsomerDataPermisson> getTCutsomerDataPermissonPage(Page<TCutsomerDataPermisson> page, TCutsomerDataPermisson tCutsomerDataPermisson) {
		return baseMapper.getTCutsomerDataPermissonPage(page, tCutsomerDataPermisson);
	}

	@Override
	public List<TCutsomerDataPermisson> getTCutsomerDataPermissonList(TCutsomerDataPermisson tCutsomerDataPermisson) {
		return baseMapper.getTCutsomerDataPermissonPage(tCutsomerDataPermisson);
	}

	@Override
	@Transactional
	public R<String> insertForCopyCutsomerDataPermisson(String[] srcUser, String[] beUser, YifuUser user) {
		if(Common.isEmpty(srcUser)){
			return R.failed("请选择要被复制人！") ;
		}
		if(Common.isEmpty(beUser)){
			return R.failed("请选择被授权的人！") ;
		}
		if(beUser.length > 1){
			return R.failed("为了避免权限混乱，暂时只支持权限复制给某一个人！") ;
		}
		List<TCutsomerDataPermisson> list = baseMapper.selectList(Wrappers.<TCutsomerDataPermisson>lambdaQuery().eq(TCutsomerDataPermisson::getUserId, srcUser[0]));
		Collection<TCutsomerDataPermisson> saveColl;
		if(Common.isNotNull(list)){
			LocalDateTime now = LocalDateTime.now();
			for(String userId : beUser){
				saveColl = getSaveDataPermissonList(user, list, now, userId);
				if(Common.isNotNull(saveColl)){
					this.saveBatch(saveColl);
				}
			}
		}else{
			return R.failed("未查到要被复制人的权限表数据，请换个人复制权限") ;
		}
		return  R.ok("操作成功");
	}
	/**
	 * 获取要新增的权限集合
	 * @Author pwang
	 * @Date 2020-09-27 17:24
	 * @param user
	 * @param list
	 * @param now
	 * @param userId
	 * @return
	 **/
	private Collection<TCutsomerDataPermisson> getSaveDataPermissonList(YifuUser user, List<TCutsomerDataPermisson> list, LocalDateTime now, String userId) {
		Collection<TCutsomerDataPermisson> result = new HashSet<>();
		Map<String, TCutsomerDataPermisson> settleDomianDataPermissonMap = new HashMap<>();
		List<TCutsomerDataPermisson> oldPermisson = baseMapper.selectList(Wrappers.<TCutsomerDataPermisson>lambdaQuery().eq(TCutsomerDataPermisson::getUserId, userId));
		//被复制的权限去重
		for(TCutsomerDataPermisson cdp : list){
			cdp.setId(null);
			cdp.setUserId(userId);
			// 注意 :人员部门、登录名等没加
			cdp.setType(CommonConstants.TWO_STRING);
			cdp.setCreateBy(user.getId());
			cdp.setCreateName(user.getNickname());
			cdp.setCreateTime(now);
			settleDomianDataPermissonMap.put(cdp.getSettleDomainId(),cdp);
		}
		//去除本身有的权限
		for(TCutsomerDataPermisson cdp : oldPermisson){
			settleDomianDataPermissonMap.remove(cdp.getSettleDomainId());
		}
		if(Common.isNotNull(settleDomianDataPermissonMap.values())){
			result.addAll(settleDomianDataPermissonMap.values());
		}
		return result;
	}


	@Override
	public boolean save(TCutsomerDataPermisson cutsomerDataPermisson){
		return super.save(cutsomerDataPermisson);
	}
}
