/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractAttachInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeLog;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TEmployeeLogMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeLogService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.equator.HrEquator;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

import static com.alibaba.fastjson.serializer.SerializerFeature.*;

/**
 * 档案变更日志表
 *
 * @author hgw
 * @date 2022-06-20 09:55:06
 */
@Service
public class TEmployeeLogServiceImpl extends ServiceImpl<TEmployeeLogMapper, TEmployeeLog> implements TEmployeeLogService {

	@Override
	public <T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo) {
		try{
			//比较记录不影响业务逻辑，用try套住
			//比较差异
			String differenceKey = HrEquator.comparisonValue(oldInfo, newInfo);
			//如果有差异保存差异
			if(!Common.isEmpty(differenceKey)){
				TEmployeeLog employeeLog = new TEmployeeLog();
				employeeLog.setProjectId(projectId);
				employeeLog.setType(type);
				employeeLog.setEmpId(empId);
				employeeLog.setCreateTime(LocalDateTime.now());
				employeeLog.setOldInfo(JSON.toJSONString(oldInfo,features));
				employeeLog.setNewInfo(JSON.toJSONString(newInfo,features));
				employeeLog.setDifferenceInfo(differenceKey);
				baseMapper.insert(employeeLog);
				return employeeLog;
			}
		}catch (Exception e){
			log.error(JSON.toJSON(oldInfo)+"插入修改记录报错>>>",e);
		}
		return null;
	}

	@Override
	public <T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo,YifuUser user) {
		try{
			//比较记录不影响业务逻辑，用try套住
			//比较差异
			String differenceKey = HrEquator.comparisonValue(oldInfo, newInfo);
			//如果有差异保存差异
			if(!Common.isEmpty(differenceKey)){
				TEmployeeLog employeeLog = new TEmployeeLog();
				employeeLog.setProjectId(projectId);
				employeeLog.setType(type);
				employeeLog.setEmpId(empId);
				employeeLog.setCreateTime(LocalDateTime.now());
				if (Common.isNotNull(user)) {
					employeeLog.setCreateBy(user.getId());
					employeeLog.setCreateName(user.getNickname());
				}
				employeeLog.setOldInfo(JSON.toJSONString(oldInfo,features));
				employeeLog.setNewInfo(JSON.toJSONString(newInfo,features));
				employeeLog.setDifferenceInfo(differenceKey);
				baseMapper.insert(employeeLog);
				return employeeLog;
			}
		}catch (Exception e){
			log.error(JSON.toJSON(oldInfo)+"插入修改记录报错>>>",e);
		}
		return null;
	}

	@Override
	public <T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo, FddContractAttachInfo fddContractAttachInfo) {
		try{
			//比较记录不影响业务逻辑，用try套住
			//比较差异
			String differenceKey = HrEquator.comparisonValue(oldInfo, newInfo);
			//如果有差异保存差异
			if(!Common.isEmpty(differenceKey)){
				TEmployeeLog employeeLog = new TEmployeeLog();
				employeeLog.setProjectId(projectId);
				employeeLog.setType(type);
				employeeLog.setEmpId(empId);
				employeeLog.setCreateTime(LocalDateTime.now());
				if (Common.isNotNull(fddContractAttachInfo)) {
					employeeLog.setCreateBy(fddContractAttachInfo.getCreateBy());
					employeeLog.setCreateName(fddContractAttachInfo.getCreateName());
					employeeLog.setUpdateBy(fddContractAttachInfo.getUpdateBy());
				}
				employeeLog.setOldInfo(JSON.toJSONString(oldInfo,features));
				employeeLog.setNewInfo(JSON.toJSONString(newInfo,features));
				employeeLog.setDifferenceInfo(differenceKey);
				baseMapper.insert(employeeLog);
				return employeeLog;
			}
		}catch (Exception e){
			log.error(JSON.toJSON(oldInfo)+"插入修改记录报错>>>",e);
		}
		return null;
	}

	private SerializerFeature[] features = new SerializerFeature[] {
			WriteMapNullValue, WriteNullNumberAsZero, WriteNullListAsEmpty,
			WriteNullStringAsEmpty,WriteDateUseDateFormat
	};
}
