package com.yifu.cloud.plus.v1.yifu.common.core.util;

import lombok.Data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * @author fang
 */
@Data
public class ErrorMessage implements Serializable {
    /**
     * 行数或INDEX
     */
    private Integer lineNum;
    //默认红色 success green
    private String color = "red";

	private Set<String> errors = new HashSet();

    /**
     * @param 用于展示勾选的名称
     * @Author: fxj
     **/
    private String name;
    /**
     * 错误信息
     */
    private String message;

    public ErrorMessage(Integer lineNum, String message) {
        this.lineNum = lineNum;
		this.color = "red";
        this.message = message;
    }
    public ErrorMessage(Integer lineNum, String message, String color) {
        this.lineNum = lineNum;
        this.color = color;
        this.message = message;
    }

    public ErrorMessage(Integer lineNum, String message, String color, String name) {
        this.lineNum = lineNum;
        this.color = color;
        this.message = message;
        this.name= name;
    }

	public ErrorMessage(Integer lineNum, Set<String> errors) {
		this.lineNum = lineNum;
		this.errors = errors;
	}
}
