package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Date 2022/7/11
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprArchivesProperties.class)
public class ArchivesDaprUtil {
	@Autowired
	private DaprArchivesProperties daprArchivesProperties;
	/**
	 * @Author fxj
	 * @Description 获取派单校验需要的档案信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	**/
	public R<Map<String, DispatchEmpVo>> getDispatchEmpVo(DispatchCheckVo checkVo){
		R<Map> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/getDispatchEmpVo" , JSON.toJSONString(checkVo), Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		Map<String,DispatchEmpVo> map  = JSON.parseObject(JSON.toJSONString(res.getData()),new TypeReference<HashMap<String,DispatchEmpVo>>(){});
		return R.ok(map);
	}
	/**
	 * @Author fxj
	 * @Description 通过项目编码获取项目及客户信息
	 * @Date 21:18 2022/7/20
	 * @Param
	 * @return
	 **/
	public R<SetInfoVo> getSetInfoByCodes(List<String> codes){
		R<SetInfoVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSetInfoByCodes",JSON.toJSONString(codes), SetInfoVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取派单校验需要的档案信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainSelectVo> getSettleDomainSelectVoById(String departId){
		TSettleDomainSelectVo settleDomainSelectVo = new TSettleDomainSelectVo();
		settleDomainSelectVo.setDepartNo(departId);
		R<TSettleDomainSelectVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainSelectVoById",settleDomainSelectVo, TSettleDomainSelectVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取派单校验需要的档案信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的项目信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> selectAllSettleDomainSelectVos(){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/selectAllSettleDomainSelectVos","", TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有客户单位的项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的项目信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> getSettleDomainIdsByUserId(String userId){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainIdsByUserId",userId, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有客户单位的项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 根据项目id 获取项目编码
	 * @Date 11:50 2022/8/9
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> selectSettleDomainSelectVoById(String id){
		TSettleDomainSelectVo settleDomainSelectVo = new TSettleDomainSelectVo();
		settleDomainSelectVo.setId(id);
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/selectSettleDomainSelectVoById",settleDomainSelectVo, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("通过项目id获取项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 根据项目id 获取项目编码
	 * @Date 11:50 2022/8/9
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> selectSettleDomainSelectVoByNo(String deptNo){
		TSettleDomainSelectVo settleDomainSelectVo = new TSettleDomainSelectVo();
		settleDomainSelectVo.setDepartNo(deptNo);
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/selectSettleDomainSelectVoByNo",settleDomainSelectVo, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("通过项目id获取项目信息失败！");
		}
		return res;
	}

	public R<EmpDispatchAddVo> addDispatchInfo(EmpDispatchAddVo addVo) {
		R<EmpDispatchAddVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/addDispatchInfo" , JSON.toJSONString(addVo), EmpDispatchAddVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("新增档案|项目档案|合同信息失败！");
		}
		return res;
	}

	/**
	 * @param empId
	 * @Description: 获取档案基本信息
	 * @Author: hgw
	 * @Date: 2022/7/21 14:48
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeInfo> getTEmployeeInfoById(String empId) {
		R<TEmployeeInfo> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/getByEmpId" , empId, TEmployeeInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}

	/**
	 * @Description: 获取项目档案基本信息
	 * @Author: hgw
	 * @Date: 2022/7/21 14:48
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeProject> getTEmployeeProjectById(TEmployeeProject employeeProject) {
		R<TEmployeeProject> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeproject/inner/getByEmpIdAndDeptId" , JSON.toJSONString(employeeProject), TEmployeeProject.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}

	/**
	 * @param id
	 * @Description: 获取档案合同
	 * @Author: fxj
	 * @Date: 2022/7/25 10:38
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeContractInfo> getContractById(String id) {
		R<TEmployeeContractInfo> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeecontractinfo/getContractById" , id, TEmployeeContractInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}
	/**
	 * @Author fxj
	 * @Description  派单审核通过 同步人员档案 项目档案 合同状态信息
	 * @Date 19:30 2022/8/1
	 * @Param type 0 审核通过  1 审核不通过
	 * @return
	 **/
	public R<Boolean> updateEmpInfo(String empIdCard, String projectNo, String contractId,String type){
		if (Common.isEmpty(empIdCard)
				|| Common.isEmpty(projectNo)
				|| Common.isEmpty(type)){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		UpdateEmpVo vo = new UpdateEmpVo();
		vo.setEmpIdCard(empIdCard);
		vo.setProjectNo(projectNo);
		vo.setContractId(contractId);
		vo.setType(type);
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/updateEmpInfo" , JSON.toJSONString(vo), Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("更新人员档案、项目档案、合同状态信息失败！");
		}
		return res;
	}
	/**
	 * @Author fxj
	 * @Description 校验手机号码重复
	 * @Date 22:11 2022/8/4
	 * @Param
	 * @return
	**/
	public R<Boolean> checkMobile(String mobile) {
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/inner/checkMobile" , mobile, Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("检验号码重复信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description  更新项目档案和人员档案的社保公积金状态
	 * 派增：
	 * 	 * 1、派单处社保或公积金状态为待审核、待办理、办理中，项目档案处社保或公积金状态为处理中1；
	 * 	 * 2、派单处社保或公积金状态为审核不通过或办理失败，项目档案处社保状态为无社保，公积金状态为无公积金0；
	 * 	 * 3、派单处社保状态为部分办理失败，项目档案处社保状态为部分购买 2
	 * 	 * 4、派单处社保或公积金状态为办理成功，项目档案处社保或公积金状态为正常 3
	 * 	 * 派减：
	 * 	 * 1、派减状态为待审核、待办理、审核不通过、办理失败，项目档案处社保或公积金状态不变；
	 * 	 * 2、派减状态为办理成功，项目档案处社保或公积金状态变为已派减 4
	 * 	 * 人员档案处社保或公积金状态根据身份证+项目进行整合：
	 * 	 * 社保状态优先级：正常>部分购买>处理中>已派减>无社保
	 * 	 * 公积金状态优先级：正常>处理中>已派减>无公积金
	 * @Date 19:30 2022/8/1
	 * @Param type 0 审核通过  1 审核不通过
	 * @return
	 **/
	public R<Boolean> updateProjectSocialFund(UpProjectSocialFundVo vo){
		if (Common.isEmpty(vo.getEmpIdCard())
				|| (Common.isEmpty(vo.getSocialStatus())
				&& Common.isEmpty(vo.getFundStatus()))
				|| Common.isEmpty(vo.getDepartNo())){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeproject/inner/updateProjectSocialFund" , JSON.toJSONString(vo), Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("更新人员档案、项目档案社保公积金状态信息失败！");
		}
		return res;
	}
}
