package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhaji
 * @description 变更所属项目
 * @date 2022-07-21 15:35:49
 */
@Data
@Tag(name = "变更所属项目")
public class DeptChangeCheckParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;
	/**
	 * 商险id
	 */
	@Schema(description = "商险id")
	private String id;
	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证号码
	 */
	@Schema(description = "员工身份证号码")
	private String empIdCardNo;

	/**
	 * 原项目编码
	 */
	@Schema(description = "原项目编码")
	private String oldDeptNo;

	/**
	 * 新项目名称
	 */
	@Schema(description = "新项目名称")
	private String newDeptName;

	/**
	 * 原项目名称
	 */
	@Schema(description = "原项目名称")
	private String oldDeptName;

	/**
	 * 新项目编码
	 */
	@Schema(description = "新项目编码")
	private String newDeptNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始日期
	 */
	@Schema(description = "保单开始日期")
	private String policyStart;

	/**
	 * 保单结束日期
	 */
	@Schema(description = "保单结束日期")
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

	/**
	 * 新项目结算方式
	 */
	@Schema(description = "新项目结算方式")
	private Integer newSettleType;

	/**
	 * 旧项目结算方式
	 */
	@Schema(description = "旧项目结算方式")
	private Integer oldSettleType;

	/**
	 * 默认结算id
	 */
	@Schema(description = "默认结算id")
	private String defaultSettleId;

	/**
	 * 预估保费
	 */
	@Schema(description = "预估保费")
	private BigDecimal estimatePremium;

	/**
	 * 实际保费
	 */
	@Schema(description = "实际保费")
	private BigDecimal actualPremium;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String newCustomerName;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String newCustomerCode;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String oldCustomerName;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String oldCustomerCode;


}
