package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author zhaji
 * @description EKP交互类
 * @date 2022-08-09 11:09:12
 */
@Data
public class EkpInteractiveParam implements Serializable {

	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 商险id
	 */
	@Schema(description = "商险id")
	private String detailId;

	/**
	 * 结算id
	 */
	@Schema(description = "结算id")
	private String defaultSettleId;


	/**
	 * 单据类型 (0、与薪资合并结算 1、单独结算)
	 */
	@Schema(description = "单据类型 (1、预估单 2、实缴单)")
	private String settleType;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String deptName;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String customerCode;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 发票号
	 */
	@Schema(description = "发票号")
	private String invoiceNo;

	/**
	 * 发生日期
	 */
	@Schema(description = "发生日期")
	private String happenDate;

	/**
	 * 保单编号
	 */
	@Schema(description = "保单编号")
	private String policyNo;

	/**
	 * 保险公司名称(冗余字段)
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

	/**
	 * 实际保费
	 */
	@Schema(description = "实际保费")
	private BigDecimal actualPremium;

	/**
	 * 预估保费
	 */
	@Schema(description = "预估保费")
	private BigDecimal estimatePremium;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

	/**
	 * 	单据状态
	 */
	@Schema(description = "状态:1新增结算单,2更新结算单信息,3作废结算单信息")
	private String interactiveType;

	/**
	 * 	EKP推送类型
	 */
	@Schema(description = "1推送预估费用,2推送实缴费用,3变更结算月,4推送作废信息,5推送预估红冲信息,6投保退回红冲，7变更保单保费，8推送实缴红冲信息")
	private Integer pushType;

	/**
	 * 	有无预估
	 */
	@Schema(description = "状态:有，无")
	private String estimateStatus;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	@ExcelIgnore
	private String bpoFlag;
}
